/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;

public class SparkArgsUtils {
    public static List<String> buildArgs(SparkParameters param) {
        String mainArgs;
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores;
        ArrayList<String> args = new ArrayList<String>();
        String deployMode = "cluster";
        args.add("--master");
        if (StringUtils.isNotEmpty((String)param.getDeployMode())) {
            deployMode = param.getDeployMode();
        }
        if (!"local".equals(deployMode)) {
            args.add("yarn");
            args.add("--deploy-mode");
        }
        args.add(param.getDeployMode());
        ProgramType type = param.getProgramType();
        String mainClass = param.getMainClass();
        if (type != null && type != ProgramType.PYTHON && StringUtils.isNotEmpty((String)mainClass)) {
            args.add("--class");
            args.add(mainClass);
        }
        if ((driverCores = param.getDriverCores()) != 0) {
            args.add("--driver-cores");
            args.add(String.format("%d", driverCores));
        }
        if (StringUtils.isNotEmpty((String)(driverMemory = param.getDriverMemory()))) {
            args.add("--driver-memory");
            args.add(driverMemory);
        }
        if ((numExecutors = param.getNumExecutors()) != 0) {
            args.add("--num-executors");
            args.add(String.format("%d", numExecutors));
        }
        if ((executorCores = param.getExecutorCores()) != 0) {
            args.add("--executor-cores");
            args.add(String.format("%d", executorCores));
        }
        if (StringUtils.isNotEmpty((String)(executorMemory = param.getExecutorMemory()))) {
            args.add("--executor-memory");
            args.add(executorMemory);
        }
        String others = param.getOthers();
        String queue = param.getQueue();
        if (StringUtils.isNotEmpty((String)others)) {
            if (!others.contains("--queue") && StringUtils.isNotEmpty((String)queue)) {
                args.add("--queue");
                args.add(queue);
            }
            args.add(others);
        } else if (StringUtils.isNotEmpty((String)queue)) {
            args.add("--queue");
            args.add(queue);
        }
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null) {
            args.add(mainJar.getRes());
        }
        if (StringUtils.isNotEmpty((String)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }
}

