/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractCommandExecutor;
import org.slf4j.Logger;

public class ShellCommandExecutor
extends AbstractCommandExecutor {
    public static final String SH = "sh";
    public static final String CMD = "cmd.exe";

    public ShellCommandExecutor(Consumer<List<String>> logHandler, TaskExecutionContext taskExecutionContext, Logger logger) {
        super(logHandler, taskExecutionContext, logger);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/%s.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), OSUtils.isWindows() ? "bat" : "command");
    }

    @Override
    protected String commandInterpreter() {
        return OSUtils.isWindows() ? CMD : SH;
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        this.logger.info("tenantCode user:{}, task dir:{}", (Object)this.taskExecutionContext.getTenantCode(), (Object)this.taskExecutionContext.getTaskAppId());
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            this.logger.info("create command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            if (OSUtils.isWindows()) {
                sb.append("@echo off\n");
                sb.append("cd /d %~dp0\n");
                if (this.taskExecutionContext.getEnvFile() != null) {
                    sb.append("call ").append(this.taskExecutionContext.getEnvFile()).append("\n");
                }
            } else {
                sb.append("#!/bin/sh\n");
                sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
                sb.append("cd $BASEDIR\n");
                if (this.taskExecutionContext.getEnvFile() != null) {
                    sb.append("source ").append(this.taskExecutionContext.getEnvFile()).append("\n");
                }
            }
            sb.append(execCommand);
            this.logger.info("command : {}", (Object)sb.toString());
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }
}

