/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.spark;

import java.util.ArrayList;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.SparkVersion;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.SparkArgsUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.slf4j.Logger;

public class SparkTask
extends AbstractYarnTask {
    private static final String SPARK1_COMMAND = "${SPARK_HOME1}/bin/spark-submit";
    private static final String SPARK2_COMMAND = "${SPARK_HOME2}/bin/spark-submit";
    private SparkParameters sparkParameters;
    private TaskExecutionContext taskExecutionContext;

    public SparkTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() {
        this.logger.info("spark task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.sparkParameters = (SparkParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SparkParameters.class);
        if (!this.sparkParameters.checkParameters()) {
            throw new RuntimeException("spark task params is not valid");
        }
        this.sparkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        if (StringUtils.isNotEmpty((CharSequence)this.sparkParameters.getMainArgs())) {
            String args = this.sparkParameters.getMainArgs();
            Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.sparkParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
            if (paramsMap != null) {
                args = ParameterUtils.convertParameterPlaceholders((String)args, ParamUtils.convert(paramsMap));
            }
            this.sparkParameters.setMainArgs(args);
        }
    }

    @Override
    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        String sparkCommand = SPARK2_COMMAND;
        if (SparkVersion.SPARK1.name().equals(this.sparkParameters.getSparkVersion())) {
            sparkCommand = SPARK1_COMMAND;
        }
        args.add(sparkCommand);
        args.addAll(SparkArgsUtils.buildArgs(this.sparkParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), this.taskExecutionContext.getDefinedParams());
        this.logger.info("spark task command : {}", (Object)command);
        return command;
    }

    @Override
    protected void setMainJarName() {
        ResourceInfo mainJar = this.sparkParameters.getMainJar();
        if (mainJar != null) {
            String resourceName;
            int resourceId = mainJar.getId();
            if (resourceId == 0) {
                resourceName = mainJar.getRes();
            } else {
                Resource resource = this.processService.getResourceById(this.sparkParameters.getMainJar().getId());
                if (resource == null) {
                    this.logger.error("resource id: {} not exist", (Object)resourceId);
                    throw new RuntimeException(String.format("resource id: %d not exist", resourceId));
                }
                resourceName = resource.getFullName().replaceFirst("/", "");
            }
            mainJar.setRes(resourceName);
            this.sparkParameters.setMainJar(mainJar);
        }
    }

    @Override
    public AbstractParameters getParameters() {
        return this.sparkParameters;
    }
}

