/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.SensitiveLogUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;

public class SensitiveDataConverter
extends MessageConverter {
    private final Pattern pwdPattern = Pattern.compile("(?<=(\"password\":\")).*?(?=(\"))");

    public String convert(ILoggingEvent event) {
        String requestLogMsg = event.getFormattedMessage();
        return this.convertMsg(requestLogMsg);
    }

    private String convertMsg(String oriLogMsg) {
        String tempLogMsg = oriLogMsg;
        if (StringUtils.isNotEmpty((CharSequence)tempLogMsg)) {
            tempLogMsg = this.passwordHandler(this.pwdPattern, tempLogMsg);
        }
        return tempLogMsg;
    }

    private String passwordHandler(Pattern pwdPattern, String logMsg) {
        Matcher matcher = pwdPattern.matcher(logMsg);
        StringBuffer sb = new StringBuffer(logMsg.length());
        while (matcher.find()) {
            String password = matcher.group();
            String maskPassword = SensitiveLogUtils.maskDataSourcePwd((String)password);
            matcher.appendReplacement(sb, maskPassword);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

