/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.model.DependentItem;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentExecute {
    private final ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    private List<DependentItem> dependItemList;
    private DependentRelation relation;
    private DependResult modelDependResult = DependResult.WAITING;
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private Logger logger = LoggerFactory.getLogger(DependentExecute.class);

    public DependentExecute(List<DependentItem> itemList, DependentRelation relation) {
        this.dependItemList = itemList;
        this.relation = relation;
    }

    private DependResult getDependentResultForItem(DependentItem dependentItem, Date currentTime) {
        List dateIntervals = DependentUtils.getDateIntervalList((Date)currentTime, (String)dependentItem.getDateValue());
        return this.calculateResultForTasks(dependentItem, dateIntervals);
    }

    private DependResult calculateResultForTasks(DependentItem dependentItem, List<DateInterval> dateIntervals) {
        DependResult result = DependResult.FAILED;
        for (DateInterval dateInterval : dateIntervals) {
            ProcessInstance processInstance = this.findLastProcessInterval(dependentItem.getDefinitionId(), dateInterval);
            if (processInstance == null) {
                return DependResult.WAITING;
            }
            result = dependentItem.getDepTasks().equals("ALL") ? this.dependResultByProcessInstance(processInstance) : this.getDependTaskResult(dependentItem.getDepTasks(), processInstance);
            if (result == DependResult.SUCCESS) continue;
            break;
        }
        return result;
    }

    private DependResult dependResultByProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.getState().typeIsFinished()) {
            return DependResult.WAITING;
        }
        if (processInstance.getState().typeIsSuccess()) {
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DependResult getDependTaskResult(String taskName, ProcessInstance processInstance) {
        TaskInstance taskInstance = null;
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(processInstance.getId()));
        for (TaskInstance task : taskInstanceList) {
            if (!task.getName().equals(taskName)) continue;
            taskInstance = task;
            break;
        }
        if (taskInstance != null) return this.getDependResultByState(taskInstance.getState());
        if (!processInstance.getState().typeIsFinished()) return DependResult.WAITING;
        return DependResult.FAILED;
    }

    private ProcessInstance findLastProcessInterval(int definitionId, DateInterval dateInterval) {
        ProcessInstance runningProcess = this.processService.findLastRunningProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime());
        if (runningProcess != null) {
            return runningProcess;
        }
        ProcessInstance lastSchedulerProcess = this.processService.findLastSchedulerProcessInterval(definitionId, dateInterval);
        ProcessInstance lastManualProcess = this.processService.findLastManualProcessInterval(definitionId, dateInterval);
        if (lastManualProcess == null) {
            return lastSchedulerProcess;
        }
        if (lastSchedulerProcess == null) {
            return lastManualProcess;
        }
        return lastManualProcess.getEndTime().after(lastSchedulerProcess.getEndTime()) ? lastManualProcess : lastSchedulerProcess;
    }

    private DependResult getDependResultByState(ExecutionStatus state) {
        if (!state.typeIsFinished()) {
            return DependResult.WAITING;
        }
        if (state.typeIsSuccess()) {
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    private DependResult getDependResultByProcessStateWhenTaskNull(ExecutionStatus state) {
        if (state.typeIsRunning() || state == ExecutionStatus.SUBMITTED_SUCCESS || state == ExecutionStatus.WAITTING_THREAD) {
            return DependResult.WAITING;
        }
        return DependResult.FAILED;
    }

    public boolean finish(Date currentTime) {
        if (this.modelDependResult == DependResult.WAITING) {
            this.modelDependResult = this.getModelDependResult(currentTime);
            return false;
        }
        return true;
    }

    public DependResult getModelDependResult(Date currentTime) {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentItem dependentItem : this.dependItemList) {
            DependResult dependResult = this.getDependResultForItem(dependentItem, currentTime);
            if (dependResult != DependResult.WAITING) {
                this.dependResultMap.put(dependentItem.getKey(), dependResult);
            }
            dependResultList.add(dependResult);
        }
        this.modelDependResult = DependentUtils.getDependResultForRelation((DependentRelation)this.relation, dependResultList);
        return this.modelDependResult;
    }

    private DependResult getDependResultForItem(DependentItem item, Date currentTime) {
        String key = item.getKey();
        if (this.dependResultMap.containsKey(key)) {
            return this.dependResultMap.get(key);
        }
        return this.getDependentResultForItem(item, currentTime);
    }

    public Map<String, DependResult> getDependResultMap() {
        return this.dependResultMap;
    }
}

