/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.processor.DBTaskAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.DBTaskResponseProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskKillProcessor;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistry;
import org.apache.dolphinscheduler.server.worker.runner.RetryReportTaskStatusThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan(value={"org.apache.dolphinscheduler"})
public class WorkerServer {
    private static final Logger logger = LoggerFactory.getLogger(WorkerServer.class);
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private WorkerRegistry workerRegistry;
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private RetryReportTaskStatusThread retryReportTaskStatusThread;

    public static void main(String[] args) {
        Thread.currentThread().setName("Worker-Server");
        new SpringApplicationBuilder(new Class[]{WorkerServer.class}).web(WebApplicationType.NONE).run(args);
    }

    @PostConstruct
    public void run() {
        logger.info("start worker server...");
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.workerConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_REQUEST, (NettyRequestProcessor)new TaskExecuteProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_REQUEST, (NettyRequestProcessor)new TaskKillProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.DB_TASK_ACK, (NettyRequestProcessor)new DBTaskAckProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.DB_TASK_RESPONSE, (NettyRequestProcessor)new DBTaskResponseProcessor());
        this.nettyRemotingServer.start();
        this.workerRegistry.registry();
        this.retryReportTaskStatusThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                WorkerServer.this.close("shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("worker server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception", (Throwable)e);
            }
            this.nettyRemotingServer.close();
            this.workerRegistry.unRegistry();
        }
        catch (Exception e) {
            logger.error("worker server stop exception ", (Throwable)e);
            System.exit(-1);
        }
    }
}

