/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.apache.dolphinscheduler.server.worker.cache.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.server.worker.cache.impl.TaskExecutionContextCacheManagerImpl;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskManager;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecuteThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteThread.class);
    private TaskExecutionContext taskExecutionContext;
    private AbstractTask task;
    private TaskCallbackService taskCallbackService;
    private TaskExecutionContextCacheManager taskExecutionContextCacheManager;

    public TaskExecuteThread(TaskExecutionContext taskExecutionContext, TaskCallbackService taskCallbackService) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskCallbackService = taskCallbackService;
        this.taskExecutionContextCacheManager = (TaskExecutionContextCacheManager)SpringApplicationContext.getBean(TaskExecutionContextCacheManagerImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskExecuteResponseCommand responseCommand = new TaskExecuteResponseCommand(this.taskExecutionContext.getTaskInstanceId());
        try {
            this.logger.info("script path : {}", (Object)this.taskExecutionContext.getExecutePath());
            TaskNode taskNode = (TaskNode)JSONObject.parseObject((String)this.taskExecutionContext.getTaskJson(), TaskNode.class);
            this.downloadResource(this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getResources(), this.logger);
            this.taskExecutionContext.setTaskParams(taskNode.getParams());
            this.taskExecutionContext.setEnvFile(CommonUtils.getSystemEnvPath());
            this.taskExecutionContext.setDefinedParams(this.getGlobalParamsMap());
            this.setTaskTimeout(this.taskExecutionContext, taskNode);
            this.taskExecutionContext.setTaskAppId(String.format("%s_%s_%s", this.taskExecutionContext.getProcessDefineId(), this.taskExecutionContext.getProcessInstanceId(), this.taskExecutionContext.getTaskInstanceId()));
            Logger taskLogger = LoggerFactory.getLogger((String)LoggerUtils.buildTaskId((String)"TASK", (int)this.taskExecutionContext.getProcessDefineId(), (int)this.taskExecutionContext.getProcessInstanceId(), (int)this.taskExecutionContext.getTaskInstanceId()));
            this.task = TaskManager.newTask(this.taskExecutionContext, taskLogger);
            this.task.init();
            this.task.handle();
            this.task.after();
            responseCommand.setStatus(this.task.getExitStatus().getCode());
            responseCommand.setEndTime(new Date());
            responseCommand.setProcessId(this.task.getProcessId());
            responseCommand.setAppIds(this.task.getAppIds());
            this.logger.info("task instance id : {},task final status : {}", (Object)this.taskExecutionContext.getTaskInstanceId(), (Object)this.task.getExitStatus());
        }
        catch (Exception e) {
            this.logger.error("task scheduler failure", (Throwable)e);
            this.kill();
            responseCommand.setStatus(ExecutionStatus.FAILURE.getCode());
            responseCommand.setEndTime(new Date());
            responseCommand.setProcessId(this.task.getProcessId());
            responseCommand.setAppIds(this.task.getAppIds());
        }
        finally {
            this.taskExecutionContextCacheManager.removeByTaskInstanceId(this.taskExecutionContext.getTaskInstanceId());
            ResponceCache.get().cache(this.taskExecutionContext.getTaskInstanceId(), responseCommand.convert2Command(), Event.RESULT);
            this.taskCallbackService.sendResult(this.taskExecutionContext.getTaskInstanceId(), responseCommand.convert2Command());
        }
    }

    private Map<String, String> getGlobalParamsMap() {
        HashMap<String, String> globalParamsMap = new HashMap<String, String>(16);
        String globalParamsStr = this.taskExecutionContext.getGlobalParams();
        if (globalParamsStr != null) {
            List globalParamsList = JSONObject.parseArray((String)globalParamsStr, Property.class);
            globalParamsMap.putAll(globalParamsList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue)));
        }
        return globalParamsMap;
    }

    private void setTaskTimeout(TaskExecutionContext taskExecutionContext, TaskNode taskNode) {
        taskExecutionContext.setTaskTimeout(Integer.MAX_VALUE);
        TaskTimeoutParameter taskTimeoutParameter = taskNode.getTaskTimeoutParameter();
        if (taskTimeoutParameter.getEnable()) {
            taskExecutionContext.setTaskTimeoutStrategy(taskTimeoutParameter.getStrategy().getCode());
            switch (taskTimeoutParameter.getStrategy()) {
                case WARN: {
                    break;
                }
                case FAILED: {
                    if (Integer.MAX_VALUE <= taskTimeoutParameter.getInterval() * 60) break;
                    taskExecutionContext.setTaskTimeout(taskTimeoutParameter.getInterval() * 60);
                    break;
                }
                case WARNFAILED: {
                    if (Integer.MAX_VALUE <= taskTimeoutParameter.getInterval() * 60) break;
                    taskExecutionContext.setTaskTimeout(taskTimeoutParameter.getInterval() * 60);
                    break;
                }
                default: {
                    this.logger.error("not support task timeout strategy: {}", (Object)taskTimeoutParameter.getStrategy());
                    throw new IllegalArgumentException("not support task timeout strategy");
                }
            }
        }
    }

    public void kill() {
        if (this.task != null) {
            try {
                this.task.cancelApplication(true);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void downloadResource(String execLocalPath, Map<String, String> projectRes, Logger logger) throws Exception {
        if (MapUtils.isEmpty(projectRes)) {
            return;
        }
        Set<Map.Entry<String, String>> resEntries = projectRes.entrySet();
        for (Map.Entry<String, String> resource : resEntries) {
            String fullName = resource.getKey();
            String tenantCode = resource.getValue();
            File resFile = new File(execLocalPath, fullName);
            if (!resFile.exists()) {
                try {
                    String resHdfsPath = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)fullName);
                    logger.info("get resource file from hdfs :{}", (Object)resHdfsPath);
                    HadoopUtils.getInstance().copyHdfsToLocal(resHdfsPath, execLocalPath + File.separator + fullName, false, true);
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
            logger.info("file : {} exists ", (Object)resFile.getName());
        }
    }
}

