/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.QueryType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.server.entity.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSourceGenerator
implements ISourceGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder result = new StringBuilder();
        try {
            BaseDataSource baseDataSource;
            SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceMysqlParameter.class);
            SqoopTaskExecutionContext sqoopTaskExecutionContext = taskExecutionContext.getSqoopTaskExecutionContext();
            if (sourceMysqlParameter != null && (baseDataSource = DataSourceFactory.getDatasource((DbType)DbType.of((int)sqoopTaskExecutionContext.getSourcetype()), (String)sqoopTaskExecutionContext.getSourceConnectionParams())) != null) {
                List mapColumnJava;
                List mapColumnHive;
                result.append(" --connect ").append(baseDataSource.getJdbcUrl()).append(" --username ").append(baseDataSource.getUser()).append(" --password ").append(baseDataSource.getPassword());
                if (sourceMysqlParameter.getSrcQueryType() == QueryType.FORM.ordinal()) {
                    if (StringUtils.isNotEmpty((String)sourceMysqlParameter.getSrcTable())) {
                        result.append(" --table ").append(sourceMysqlParameter.getSrcTable());
                    }
                    if (StringUtils.isNotEmpty((String)sourceMysqlParameter.getSrcColumns())) {
                        result.append(" --columns ").append(sourceMysqlParameter.getSrcColumns());
                    }
                } else if (sourceMysqlParameter.getSrcQueryType() == QueryType.SQL.ordinal() && StringUtils.isNotEmpty((String)sourceMysqlParameter.getSrcQuerySql())) {
                    String srcQuery = sourceMysqlParameter.getSrcQuerySql();
                    srcQuery = srcQuery.toLowerCase().contains("where") ? srcQuery + " AND $CONDITIONS" : srcQuery + " WHERE $CONDITIONS";
                    result.append(" --query '").append(srcQuery).append("'");
                }
                if ((mapColumnHive = sourceMysqlParameter.getMapColumnHive()) != null && !mapColumnHive.isEmpty()) {
                    StringBuilder columnMap = new StringBuilder();
                    for (Property item : mapColumnHive) {
                        columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((String)columnMap.toString())) {
                        result.append(" --map-column-hive ").append(columnMap.substring(0, columnMap.length() - 1));
                    }
                }
                if ((mapColumnJava = sourceMysqlParameter.getMapColumnJava()) != null && !mapColumnJava.isEmpty()) {
                    StringBuilder columnMap = new StringBuilder();
                    for (Property item : mapColumnJava) {
                        columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((String)columnMap.toString())) {
                        result.append(" --map-column-java ").append(columnMap.substring(0, columnMap.length() - 1));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return result.toString();
    }
}

