/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import java.util.Collection;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWeight;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.Selector;

public class LowerWeightRoundRobin
implements Selector<HostWeight> {
    @Override
    public HostWeight select(Collection<HostWeight> sources) {
        int totalWeight = 0;
        int lowWeight = 0;
        HostWeight lowerNode = null;
        for (HostWeight hostWeight : sources) {
            totalWeight += hostWeight.getWeight();
            hostWeight.setCurrentWeight(hostWeight.getCurrentWeight() + hostWeight.getWeight());
            if (lowerNode != null && lowWeight <= hostWeight.getCurrentWeight()) continue;
            lowerNode = hostWeight;
            lowWeight = hostWeight.getCurrentWeight();
        }
        lowerNode.setCurrentWeight(lowerNode.getCurrentWeight() + totalWeight);
        return lowerNode;
    }
}

