/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.apache.dolphinscheduler.server.utils.DependentExecute;
import org.slf4j.LoggerFactory;

public class DependentTaskExecThread
extends MasterBaseTaskExecThread {
    private DependentParameters dependentParameters;
    private List<DependentExecute> dependentTaskList = new ArrayList<DependentExecute>();
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private Date dependentDate;

    public DependentTaskExecThread(TaskInstance taskInstance) {
        super(taskInstance);
    }

    @Override
    public Boolean submitWaitComplete() {
        try {
            this.logger.info("dependent task start");
            this.taskInstance = this.submit();
            this.logger = LoggerFactory.getLogger((String)LoggerUtils.buildTaskId((String)"TASK", (int)this.taskInstance.getProcessDefinitionId(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
            String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.processService.formatTaskAppId(this.taskInstance));
            Thread.currentThread().setName(threadLoggerInfoName);
            this.initTaskParameters();
            this.initDependParameters();
            this.waitTaskQuit();
            this.updateTaskState();
        }
        catch (Exception e) {
            this.logger.error("dependent task run exception", (Throwable)e);
        }
        return true;
    }

    private void initDependParameters() {
        this.dependentParameters = (DependentParameters)JSONUtils.parseObject((String)this.taskInstance.getDependency(), DependentParameters.class);
        for (DependentTaskModel taskModel : this.dependentParameters.getDependTaskList()) {
            this.dependentTaskList.add(new DependentExecute(taskModel.getDependItemList(), taskModel.getRelation()));
        }
        this.dependentDate = this.processInstance.getScheduleTime() != null ? this.processInstance.getScheduleTime() : new Date();
    }

    private void updateTaskState() {
        DependResult result;
        ExecutionStatus status = this.cancel ? ExecutionStatus.KILL : ((result = this.getTaskDependResult()) == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE);
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
    }

    private Boolean waitTaskQuit() {
        this.logger.info("wait depend task : {} complete", (Object)this.taskInstance.getName());
        if (this.taskInstance.getState().typeIsFinished()) {
            this.logger.info("task {} already complete. task state:{}", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getState());
            return true;
        }
        while (Stopper.isRunning()) {
            try {
                if (this.processInstance == null) {
                    this.logger.error("process instance not exists , master task exec thread exit");
                    return true;
                }
                if (this.checkTaskTimeout()) {
                    this.checkTimeoutFlag = !this.alertTimeout();
                    this.handleTimeoutFailed();
                }
                if (this.cancel || this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                    this.cancelTaskInstance();
                    break;
                }
                if (this.allDependentTaskFinish() || this.taskInstance.getState().typeIsFinished()) break;
                this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
                this.processInstance = this.processService.findProcessInstanceById(this.processInstance.getId());
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.error("exception", (Throwable)e);
                if (this.processInstance == null) continue;
                this.logger.error("wait task quit failed, instance id:{}, task id:{}", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
            }
        }
        return true;
    }

    private void cancelTaskInstance() {
        this.cancel = true;
    }

    private void initTaskParameters() {
        this.taskInstance.setLogPath(this.getTaskLogPath(this.taskInstance));
        this.taskInstance.setHost(OSUtils.getHost() + ":" + this.masterConfig.getListenPort());
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
    }

    private boolean allDependentTaskFinish() {
        boolean finish = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            for (Map.Entry<String, DependResult> entry : dependentExecute.getDependResultMap().entrySet()) {
                if (this.dependResultMap.containsKey(entry.getKey())) continue;
                this.dependResultMap.put(entry.getKey(), entry.getValue());
                this.logger.info("dependent item complete {} {},{}", new Object[]{":||", entry.getKey(), entry.getValue()});
            }
            if (dependentExecute.finish(this.dependentDate)) continue;
            finish = false;
        }
        return finish;
    }

    private DependResult getTaskDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate);
            dependResultList.add(dependResult);
        }
        DependResult result = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), dependResultList);
        this.logger.info("dependent task completed, dependent result:{}", (Object)result);
        return result;
    }
}

