/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.HttpMethod;
import org.apache.dolphinscheduler.common.enums.HttpParametersType;
import org.apache.dolphinscheduler.common.process.HttpProperty;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.http.HttpParameters;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpTask
extends AbstractTask {
    private HttpParameters httpParameters;
    protected static final int MAX_CONNECTION_MILLISECONDS = 60000;
    protected static final String APPLICATION_JSON = "application/json";
    protected String output;
    private TaskExecutionContext taskExecutionContext;

    public HttpTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() {
        this.logger.info("http task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.httpParameters = (HttpParameters)JSONObject.parseObject((String)this.taskExecutionContext.getTaskParams(), HttpParameters.class);
        if (!this.httpParameters.checkParameters()) {
            throw new RuntimeException("http task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskExecutionContext.getTaskAppId());
        Thread.currentThread().setName(threadLoggerInfoName);
        long startTime = System.currentTimeMillis();
        String statusCode = null;
        String body = null;
        try (CloseableHttpClient client = this.createHttpClient();
             CloseableHttpResponse response = this.sendRequest(client);){
            statusCode = String.valueOf(this.getStatusCode(response));
            body = this.getResponseBody(response);
            this.exitStatusCode = this.validResponse(body, statusCode);
            long costTime = System.currentTimeMillis() - startTime;
            this.logger.info("startTime: {}, httpUrl: {}, httpMethod: {}, costTime : {}Millisecond, statusCode : {}, body : {}, log : {}", new Object[]{DateUtils.format2Readable((long)startTime), this.httpParameters.getUrl(), this.httpParameters.getHttpMethod(), costTime, statusCode, body, this.output});
        }
        catch (Exception e) {
            this.appendMessage(e.toString());
            this.exitStatusCode = -1;
            this.logger.error("httpUrl[" + this.httpParameters.getUrl() + "] connection failed\uff1a" + this.output, (Throwable)e);
            throw e;
        }
    }

    protected CloseableHttpResponse sendRequest(CloseableHttpClient client) throws IOException {
        RequestBuilder builder = this.createRequestBuilder();
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.httpParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
        ArrayList<HttpProperty> httpPropertyList = new ArrayList<HttpProperty>();
        if (CollectionUtils.isNotEmpty((Collection)this.httpParameters.getHttpParams())) {
            for (HttpProperty httpProperty : this.httpParameters.getHttpParams()) {
                String jsonObject = JSON.toJSONString((Object)httpProperty);
                String params = ParameterUtils.convertParameterPlaceholders((String)jsonObject, ParamUtils.convert(paramsMap));
                this.logger.info("http request params\uff1a{}", (Object)params);
                httpPropertyList.add((HttpProperty)JSON.parseObject((String)params, HttpProperty.class));
            }
        }
        this.addRequestParams(builder, httpPropertyList);
        String requestUrl = ParameterUtils.convertParameterPlaceholders((String)this.httpParameters.getUrl(), ParamUtils.convert(paramsMap));
        HttpUriRequest request = builder.setUri(requestUrl).build();
        this.setHeaders(request, httpPropertyList);
        return client.execute(request);
    }

    protected String getResponseBody(CloseableHttpResponse httpResponse) throws ParseException, IOException {
        if (httpResponse == null) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
    }

    protected int getStatusCode(CloseableHttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected int validResponse(String body, String statusCode) {
        int exitStatusCode = 0;
        switch (this.httpParameters.getHttpCheckCondition()) {
            case BODY_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && body.contains(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " doesn contain " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            case BODY_NOT_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && !body.contains(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " contains " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            case STATUS_CODE_CUSTOM: {
                if (statusCode.equals(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " statuscode: " + statusCode + ", Must be: " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            default: {
                if ("200".equals(statusCode)) break;
                this.appendMessage(this.httpParameters.getUrl() + " statuscode: " + statusCode + ", Must be: 200");
                exitStatusCode = -1;
            }
        }
        return exitStatusCode;
    }

    public String getOutput() {
        return this.output;
    }

    protected void appendMessage(String message) {
        if (this.output == null) {
            this.output = "";
        }
        if (message != null && !message.trim().isEmpty()) {
            this.output = this.output + message;
        }
    }

    protected void addRequestParams(RequestBuilder builder, List<HttpProperty> httpPropertyList) {
        if (CollectionUtils.isNotEmpty(httpPropertyList)) {
            JSONObject jsonParam = new JSONObject();
            for (HttpProperty property : httpPropertyList) {
                if (property.getHttpParametersType() == null) continue;
                if (property.getHttpParametersType().equals((Object)HttpParametersType.PARAMETER)) {
                    builder.addParameter(property.getProp(), property.getValue());
                    continue;
                }
                if (!property.getHttpParametersType().equals((Object)HttpParametersType.BODY)) continue;
                jsonParam.put(property.getProp(), (Object)property.getValue());
            }
            StringEntity postingString = new StringEntity(jsonParam.toString(), Charsets.UTF_8);
            postingString.setContentEncoding(StandardCharsets.UTF_8.name());
            postingString.setContentType(APPLICATION_JSON);
            builder.setEntity((HttpEntity)postingString);
        }
    }

    protected void setHeaders(HttpUriRequest request, List<HttpProperty> httpPropertyList) {
        if (CollectionUtils.isNotEmpty(httpPropertyList)) {
            for (HttpProperty property : httpPropertyList) {
                if (!HttpParametersType.HEADERS.equals((Object)property.getHttpParametersType())) continue;
                request.addHeader(property.getProp(), property.getValue());
            }
        }
    }

    protected CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = this.requestConfig();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    private RequestConfig requestConfig() {
        return RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
    }

    protected RequestBuilder createRequestBuilder() {
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return RequestBuilder.get();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.POST)) {
            return RequestBuilder.post();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.HEAD)) {
            return RequestBuilder.head();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.PUT)) {
            return RequestBuilder.put();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.DELETE)) {
            return RequestBuilder.delete();
        }
        return null;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.httpParameters;
    }
}

