/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.mr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.mr.MapreduceParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.slf4j.Logger;

public class MapReduceTask
extends AbstractYarnTask {
    private MapreduceParameters mapreduceParameters;
    private TaskExecutionContext taskExecutionContext;

    public MapReduceTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() {
        this.logger.info("mapreduce task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.mapreduceParameters = (MapreduceParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), MapreduceParameters.class);
        if (!this.mapreduceParameters.checkParameters()) {
            throw new RuntimeException("mapreduce task params is not valid");
        }
        this.mapreduceParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.mapreduceParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
        if (paramsMap != null) {
            String args = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getMainArgs(), ParamUtils.convert(paramsMap));
            this.mapreduceParameters.setMainArgs(args);
            if (this.mapreduceParameters.getProgramType() != null && this.mapreduceParameters.getProgramType() == ProgramType.PYTHON) {
                String others = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getOthers(), ParamUtils.convert(paramsMap));
                this.mapreduceParameters.setOthers(others);
            }
        }
    }

    @Override
    protected String buildCommand() throws Exception {
        List<String> parameterList = this.buildParameters(this.mapreduceParameters);
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", parameterList), this.taskExecutionContext.getDefinedParams());
        this.logger.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    @Override
    protected void setMainJarName() {
        ResourceInfo mainJar = this.mapreduceParameters.getMainJar();
        if (mainJar != null) {
            String resourceName;
            int resourceId = mainJar.getId();
            if (resourceId == 0) {
                resourceName = mainJar.getRes();
            } else {
                Resource resource = this.processService.getResourceById(this.mapreduceParameters.getMainJar().getId());
                if (resource == null) {
                    this.logger.error("resource id: {} not exist", (Object)resourceId);
                    throw new RuntimeException(String.format("resource id: %d not exist", resourceId));
                }
                resourceName = resource.getFullName().replaceFirst("/", "");
            }
            mainJar.setRes(resourceName);
            this.mapreduceParameters.setMainJar(mainJar);
        }
    }

    @Override
    public AbstractParameters getParameters() {
        return this.mapreduceParameters;
    }

    private List<String> buildParameters(MapreduceParameters mapreduceParameters) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("hadoop");
        if (mapreduceParameters.getMainJar() != null) {
            result.add("jar");
            result.add(mapreduceParameters.getMainJar().getRes());
        }
        if (!ProgramType.PYTHON.equals((Object)mapreduceParameters.getProgramType()) && StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getMainClass())) {
            result.add(mapreduceParameters.getMainClass());
        }
        if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getOthers())) {
            String others = mapreduceParameters.getOthers();
            if (!others.contains("mapreduce.job.queuename") && StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getQueue())) {
                result.add(String.format("%s %s=%s", "-D", "mapreduce.job.queuename", mapreduceParameters.getQueue()));
            }
            result.add(mapreduceParameters.getOthers());
        } else if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getQueue())) {
            result.add(String.format("%s %s=%s", "-D", "mapreduce.job.queuename", mapreduceParameters.getQueue()));
        }
        if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getMainArgs())) {
            result.add(mapreduceParameters.getMainArgs());
        }
        return result;
    }
}

