/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.SqoopQueryType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.server.entity.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MysqlSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder mysqlSourceSb = new StringBuilder();
        try {
            BaseDataSource baseDataSource;
            SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceMysqlParameter.class);
            SqoopTaskExecutionContext sqoopTaskExecutionContext = taskExecutionContext.getSqoopTaskExecutionContext();
            if (null != sourceMysqlParameter && null != (baseDataSource = DataSourceFactory.getDatasource((DbType)DbType.of((int)sqoopTaskExecutionContext.getSourcetype()), (String)sqoopTaskExecutionContext.getSourceConnectionParams()))) {
                List mapColumnJava;
                List mapColumnHive;
                mysqlSourceSb.append(" ").append("--connect").append(" ").append("\"").append(baseDataSource.getJdbcUrl()).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(baseDataSource.getPassword()).append("\"");
                if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                    if (StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcTable())) {
                        mysqlSourceSb.append(" ").append("--table").append(" ").append(sourceMysqlParameter.getSrcTable());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcColumns())) {
                        mysqlSourceSb.append(" ").append("--columns").append(" ").append(sourceMysqlParameter.getSrcColumns());
                    }
                } else if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcQuerySql())) {
                    String srcQuery = sourceMysqlParameter.getSrcQuerySql();
                    mysqlSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                    if (srcQuery.toLowerCase().contains("where")) {
                        mysqlSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                    } else {
                        mysqlSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                    }
                }
                if (null != (mapColumnHive = sourceMysqlParameter.getMapColumnHive()) && !mapColumnHive.isEmpty()) {
                    StringBuilder columnMap = new StringBuilder();
                    for (Property item : mapColumnHive) {
                        if (item.getProp().isEmpty()) continue;
                        columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                        mysqlSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
                    }
                }
                if (null != (mapColumnJava = sourceMysqlParameter.getMapColumnJava()) && !mapColumnJava.isEmpty()) {
                    StringBuilder columnJavaMap = new StringBuilder();
                    for (Property item : mapColumnJava) {
                        if (item.getProp().isEmpty()) continue;
                        columnJavaMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnJavaMap.toString())) {
                        mysqlSourceSb.append(" ").append("--map-column-java").append(" ").append(columnJavaMap.substring(0, columnJavaMap.length() - 1));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task mysql source params build failed: [%s]", e.getMessage()));
        }
        return mysqlSourceSb.toString();
    }
}

