/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.builder;

import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.entity.DataxTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.ProcedureTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.SQLTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;

public class TaskExecutionContextBuilder {
    private TaskExecutionContext taskExecutionContext = new TaskExecutionContext();

    public static TaskExecutionContextBuilder get() {
        return new TaskExecutionContextBuilder();
    }

    public TaskExecutionContextBuilder buildTaskInstanceRelatedInfo(TaskInstance taskInstance) {
        this.taskExecutionContext.setTaskInstanceId(taskInstance.getId());
        this.taskExecutionContext.setTaskName(taskInstance.getName());
        this.taskExecutionContext.setStartTime(taskInstance.getStartTime());
        this.taskExecutionContext.setTaskType(taskInstance.getTaskType());
        this.taskExecutionContext.setLogPath(taskInstance.getLogPath());
        this.taskExecutionContext.setExecutePath(taskInstance.getExecutePath());
        this.taskExecutionContext.setTaskJson(taskInstance.getTaskJson());
        this.taskExecutionContext.setWorkerGroup(taskInstance.getWorkerGroup());
        this.taskExecutionContext.setHost(taskInstance.getHost());
        this.taskExecutionContext.setResources(taskInstance.getResources());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessInstanceRelatedInfo(ProcessInstance processInstance) {
        this.taskExecutionContext.setProcessInstanceId(processInstance.getId());
        this.taskExecutionContext.setScheduleTime(processInstance.getScheduleTime());
        this.taskExecutionContext.setGlobalParams(processInstance.getGlobalParams());
        this.taskExecutionContext.setExecutorId(processInstance.getExecutorId());
        this.taskExecutionContext.setCmdTypeIfComplement(processInstance.getCmdTypeIfComplement().getCode());
        this.taskExecutionContext.setTenantCode(processInstance.getTenantCode());
        this.taskExecutionContext.setQueue(processInstance.getQueue());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessDefinitionRelatedInfo(ProcessDefinition processDefinition) {
        this.taskExecutionContext.setProcessDefineId(processDefinition.getId());
        this.taskExecutionContext.setProjectId(processDefinition.getProjectId());
        return this;
    }

    public TaskExecutionContextBuilder buildSQLTaskRelatedInfo(SQLTaskExecutionContext sqlTaskExecutionContext) {
        this.taskExecutionContext.setSqlTaskExecutionContext(sqlTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildDataxTaskRelatedInfo(DataxTaskExecutionContext dataxTaskExecutionContext) {
        this.taskExecutionContext.setDataxTaskExecutionContext(dataxTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildProcedureTaskRelatedInfo(ProcedureTaskExecutionContext procedureTaskExecutionContext) {
        this.taskExecutionContext.setProcedureTaskExecutionContext(procedureTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildSqoopTaskRelatedInfo(SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        this.taskExecutionContext.setSqoopTaskExecutionContext(sqoopTaskExecutionContext);
        return this;
    }

    public TaskExecutionContext create() {
        return this.taskExecutionContext;
    }
}

