/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import org.apache.dolphinscheduler.common.Constants;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"master.properties"})
public class MasterConfig {
    @Value(value="${master.exec.threads:100}")
    private int masterExecThreads;
    @Value(value="${master.exec.task.num:20}")
    private int masterExecTaskNum;
    @Value(value="${master.heartbeat.interval:10}")
    private int masterHeartbeatInterval;
    @Value(value="${master.task.commit.retryTimes:5}")
    private int masterTaskCommitRetryTimes;
    @Value(value="${master.dispatch.task.num :3}")
    private int masterDispatchTaskNumber;
    @Value(value="${master.task.commit.interval:1000}")
    private int masterTaskCommitInterval;
    @Value(value="${master.max.cpuload.avg:-1}")
    private double masterMaxCpuloadAvg;
    @Value(value="${master.reserved.memory:0.3}")
    private double masterReservedMemory;
    @Value(value="${master.host.selector:lowerWeight}")
    private String hostSelector;
    @Value(value="${master.listen.port:5678}")
    private int listenPort;

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public String getHostSelector() {
        return this.hostSelector;
    }

    public void setHostSelector(String hostSelector) {
        this.hostSelector = hostSelector;
    }

    public int getMasterExecThreads() {
        return this.masterExecThreads;
    }

    public void setMasterExecThreads(int masterExecThreads) {
        this.masterExecThreads = masterExecThreads;
    }

    public int getMasterExecTaskNum() {
        return this.masterExecTaskNum;
    }

    public void setMasterExecTaskNum(int masterExecTaskNum) {
        this.masterExecTaskNum = masterExecTaskNum;
    }

    public int getMasterHeartbeatInterval() {
        return this.masterHeartbeatInterval;
    }

    public void setMasterHeartbeatInterval(int masterHeartbeatInterval) {
        this.masterHeartbeatInterval = masterHeartbeatInterval;
    }

    public int getMasterTaskCommitRetryTimes() {
        return this.masterTaskCommitRetryTimes;
    }

    public void setMasterTaskCommitRetryTimes(int masterTaskCommitRetryTimes) {
        this.masterTaskCommitRetryTimes = masterTaskCommitRetryTimes;
    }

    public int getMasterTaskCommitInterval() {
        return this.masterTaskCommitInterval;
    }

    public void setMasterTaskCommitInterval(int masterTaskCommitInterval) {
        this.masterTaskCommitInterval = masterTaskCommitInterval;
    }

    public double getMasterMaxCpuloadAvg() {
        if (this.masterMaxCpuloadAvg == -1.0) {
            return Constants.DEFAULT_MASTER_CPU_LOAD;
        }
        return this.masterMaxCpuloadAvg;
    }

    public void setMasterMaxCpuloadAvg(double masterMaxCpuloadAvg) {
        this.masterMaxCpuloadAvg = masterMaxCpuloadAvg;
    }

    public double getMasterReservedMemory() {
        return this.masterReservedMemory;
    }

    public void setMasterReservedMemory(double masterReservedMemory) {
        this.masterReservedMemory = masterReservedMemory;
    }

    public int getMasterDispatchTaskNumber() {
        return this.masterDispatchTaskNumber;
    }

    public void setMasterDispatchTaskNumber(int masterDispatchTaskNumber) {
        this.masterDispatchTaskNumber = masterDispatchTaskNumber;
    }
}

