/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterRegistry {
    private final Logger logger = LoggerFactory.getLogger(MasterRegistry.class);
    @Autowired
    private ZookeeperRegistryCenter zookeeperRegistryCenter;
    @Autowired
    private MasterConfig masterConfig;
    private ScheduledExecutorService heartBeatExecutor;
    private String startTime;

    @PostConstruct
    public void init() {
        this.startTime = DateUtils.dateToString((Date)new Date());
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
    }

    public void registry() {
        final String address = OSUtils.getHost();
        final String localNodePath = this.getMasterPath();
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().persistEphemeral(localNodePath, "");
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().getZkClient().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState == ConnectionState.LOST) {
                    MasterRegistry.this.logger.error("master : {} connection lost from zookeeper", (Object)address);
                } else if (newState == ConnectionState.RECONNECTED) {
                    MasterRegistry.this.logger.info("master : {} reconnected to zookeeper", (Object)address);
                    MasterRegistry.this.zookeeperRegistryCenter.getZookeeperCachedOperator().persistEphemeral(localNodePath, "");
                } else if (newState == ConnectionState.SUSPENDED) {
                    MasterRegistry.this.logger.warn("master : {} connection SUSPENDED ", (Object)address);
                }
            }
        });
        int masterHeartbeatInterval = this.masterConfig.getMasterHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startTime, this.masterConfig.getMasterReservedMemory(), this.masterConfig.getMasterMaxCpuloadAvg(), Sets.newHashSet((Object[])new String[]{this.getMasterPath()}), this.zookeeperRegistryCenter);
        this.heartBeatExecutor.scheduleAtFixedRate(heartBeatTask, masterHeartbeatInterval, masterHeartbeatInterval, TimeUnit.SECONDS);
        this.logger.info("master node : {} registry to ZK successfully with heartBeatInterval : {}s", (Object)address, (Object)masterHeartbeatInterval);
    }

    public void unRegistry() {
        String address = this.getLocalAddress();
        String localNodePath = this.getMasterPath();
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().remove(localNodePath);
        this.logger.info("master node : {} unRegistry to ZK.", (Object)address);
    }

    private String getMasterPath() {
        String address = this.getLocalAddress();
        String localNodePath = this.zookeeperRegistryCenter.getMasterPath() + "/" + address;
        return localNodePath;
    }

    private String getLocalAddress() {
        return OSUtils.getAddr((int)this.masterConfig.getListenPort());
    }
}

