/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.model.DependentItem;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.slf4j.LoggerFactory;

public class ConditionsTaskExecThread
extends MasterBaseTaskExecThread {
    private DependentParameters dependentParameters;
    private Map<String, ExecutionStatus> completeTaskList = new ConcurrentHashMap<String, ExecutionStatus>();
    private DependResult conditionResult;

    public ConditionsTaskExecThread(TaskInstance taskInstance) {
        super(taskInstance);
    }

    @Override
    public Boolean submitWaitComplete() {
        try {
            this.taskInstance = this.submit();
            this.logger = LoggerFactory.getLogger((String)LoggerUtils.buildTaskId((String)"TASK", (int)this.taskInstance.getProcessDefinitionId(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
            String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.processService.formatTaskAppId(this.taskInstance));
            Thread.currentThread().setName(threadLoggerInfoName);
            this.initTaskParameters();
            this.logger.info("dependent task start");
            this.waitTaskQuit();
            this.updateTaskState();
        }
        catch (Exception e) {
            this.logger.error("conditions task run exception", (Throwable)e);
        }
        return true;
    }

    private void waitTaskQuit() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        for (TaskInstance task : taskInstances) {
            this.completeTaskList.putIfAbsent(task.getName(), task.getState());
        }
        ArrayList<DependResult> modelResultList = new ArrayList<DependResult>();
        for (DependentTaskModel dependentTaskModel : this.dependentParameters.getDependTaskList()) {
            ArrayList<DependResult> itemDependResult = new ArrayList<DependResult>();
            for (DependentItem item : dependentTaskModel.getDependItemList()) {
                itemDependResult.add(this.getDependResultForItem(item));
            }
            DependResult modelResult = DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), itemDependResult);
            modelResultList.add(modelResult);
        }
        this.conditionResult = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), modelResultList);
        this.logger.info("the conditions task depend result : {}", (Object)this.conditionResult);
    }

    private void updateTaskState() {
        ExecutionStatus status = this.cancel ? ExecutionStatus.KILL : (this.conditionResult == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE);
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
    }

    private void initTaskParameters() {
        this.taskInstance.setLogPath(this.getTaskLogPath(this.taskInstance));
        this.taskInstance.setHost(OSUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.dependentParameters = (DependentParameters)JSONUtils.parseObject((String)this.taskInstance.getDependency(), DependentParameters.class);
    }

    private DependResult getDependResultForItem(DependentItem item) {
        DependResult dependResult = DependResult.SUCCESS;
        if (!this.completeTaskList.containsKey(item.getDepTasks())) {
            this.logger.info("depend item: {} have not completed yet.", (Object)item.getDepTasks());
            dependResult = DependResult.FAILED;
            return dependResult;
        }
        ExecutionStatus executionStatus = this.completeTaskList.get(item.getDepTasks());
        if (executionStatus != item.getStatus()) {
            this.logger.info("depend item : {} expect status: {}, actual status: {}", new Object[]{item.getDepTasks(), item.getStatus(), executionStatus});
            dependResult = DependResult.FAILED;
        }
        this.logger.info("dependent item complete {} {},{}", new Object[]{":||", item.getDepTasks(), dependResult});
        return dependResult;
    }
}

