/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.util.Set;
import org.apache.dolphinscheduler.common.Constants;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"worker.properties"})
public class WorkerConfig {
    @Value(value="${worker.exec.threads:100}")
    private int workerExecThreads;
    @Value(value="${worker.heartbeat.interval:10}")
    private int workerHeartbeatInterval;
    @Value(value="${worker.fetch.task.num:3}")
    private int workerFetchTaskNum;
    @Value(value="${worker.max.cpuload.avg:-1}")
    private int workerMaxCpuloadAvg;
    @Value(value="${worker.reserved.memory:0.3}")
    private double workerReservedMemory;
    @Value(value="#{'${worker.groups:default}'.split(',')}")
    private Set<String> workerGroups;
    @Value(value="${worker.listen.port: 1234}")
    private int listenPort;

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public Set<String> getWorkerGroups() {
        return this.workerGroups;
    }

    public void setWorkerGroups(Set<String> workerGroups) {
        this.workerGroups = workerGroups;
    }

    public int getWorkerExecThreads() {
        return this.workerExecThreads;
    }

    public void setWorkerExecThreads(int workerExecThreads) {
        this.workerExecThreads = workerExecThreads;
    }

    public int getWorkerHeartbeatInterval() {
        return this.workerHeartbeatInterval;
    }

    public void setWorkerHeartbeatInterval(int workerHeartbeatInterval) {
        this.workerHeartbeatInterval = workerHeartbeatInterval;
    }

    public int getWorkerFetchTaskNum() {
        return this.workerFetchTaskNum;
    }

    public void setWorkerFetchTaskNum(int workerFetchTaskNum) {
        this.workerFetchTaskNum = workerFetchTaskNum;
    }

    public double getWorkerReservedMemory() {
        return this.workerReservedMemory;
    }

    public void setWorkerReservedMemory(double workerReservedMemory) {
        this.workerReservedMemory = workerReservedMemory;
    }

    public int getWorkerMaxCpuloadAvg() {
        if (this.workerMaxCpuloadAvg == -1) {
            return Constants.DEFAULT_WORKER_CPU_LOAD;
        }
        return this.workerMaxCpuloadAvg;
    }

    public void setWorkerMaxCpuloadAvg(int workerMaxCpuloadAvg) {
        this.workerMaxCpuloadAvg = workerMaxCpuloadAvg;
    }
}

