/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.python;

import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.python.PythonParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.CommandExecuteResult;
import org.apache.dolphinscheduler.server.worker.task.PythonCommandExecutor;
import org.slf4j.Logger;

public class PythonTask
extends AbstractTask {
    private PythonParameters pythonParameters;
    private String taskDir;
    private PythonCommandExecutor pythonCommandExecutor;
    private TaskExecutionContext taskExecutionContext;

    public PythonTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
        this.pythonCommandExecutor = new PythonCommandExecutor(this::logHandle, taskExecutionContext, logger);
    }

    @Override
    public void init() {
        this.logger.info("python task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.pythonParameters = (PythonParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), PythonParameters.class);
        if (!this.pythonParameters.checkParameters()) {
            throw new RuntimeException("python task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        try {
            CommandExecuteResult commandExecuteResult = this.pythonCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(commandExecuteResult.getAppIds());
            this.setProcessId(commandExecuteResult.getProcessId());
        }
        catch (Exception e) {
            this.logger.error("python task failure", (Throwable)e);
            this.setExitStatusCode(-1);
            throw e;
        }
    }

    @Override
    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.pythonCommandExecutor.cancelApplication();
    }

    private String buildCommand() throws Exception {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.pythonParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
        if (paramsMap != null) {
            rawPythonScript = ParameterUtils.convertParameterPlaceholders((String)rawPythonScript, ParamUtils.convert(paramsMap));
        }
        this.logger.info("raw python script : {}", (Object)this.pythonParameters.getRawScript());
        this.logger.info("task dir : {}", (Object)this.taskDir);
        return rawPythonScript;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.pythonParameters;
    }
}

