/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets;

import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetMysqlParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.server.entity.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MysqlTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder mysqlTargetSb = new StringBuilder();
        try {
            BaseDataSource baseDataSource;
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetMysqlParameter.class);
            SqoopTaskExecutionContext sqoopTaskExecutionContext = taskExecutionContext.getSqoopTaskExecutionContext();
            if (null != targetMysqlParameter && targetMysqlParameter.getTargetDatasource() != 0 && null != (baseDataSource = DataSourceFactory.getDatasource((DbType)DbType.of((int)sqoopTaskExecutionContext.getTargetType()), (String)sqoopTaskExecutionContext.getTargetConnectionParams()))) {
                mysqlTargetSb.append(" ").append("--connect").append(" ").append("\"").append(baseDataSource.getJdbcUrl()).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(baseDataSource.getPassword()).append("\"").append(" ").append("--table").append(" ").append(targetMysqlParameter.getTargetTable());
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetColumns())) {
                    mysqlTargetSb.append(" ").append("--columns").append(" ").append(targetMysqlParameter.getTargetColumns());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getFieldsTerminated())) {
                    mysqlTargetSb.append(" ").append("--fields-terminated-by");
                    if (targetMysqlParameter.getFieldsTerminated().contains("'")) {
                        mysqlTargetSb.append(" ").append(targetMysqlParameter.getFieldsTerminated());
                    } else {
                        mysqlTargetSb.append(" ").append("'").append(targetMysqlParameter.getFieldsTerminated()).append("'");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getLinesTerminated())) {
                    mysqlTargetSb.append(" ").append("--lines-terminated-by");
                    if (targetMysqlParameter.getLinesTerminated().contains("'")) {
                        mysqlTargetSb.append(" ").append(targetMysqlParameter.getLinesTerminated());
                    } else {
                        mysqlTargetSb.append(" ").append("'").append(targetMysqlParameter.getLinesTerminated()).append("'");
                    }
                }
                if (targetMysqlParameter.getIsUpdate() && StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetUpdateMode())) {
                    mysqlTargetSb.append(" ").append("--update-key").append(" ").append(targetMysqlParameter.getTargetUpdateKey()).append(" ").append("--update-mode").append(" ").append(targetMysqlParameter.getTargetUpdateMode());
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop mysql target params build failed: [%s]", e.getMessage()));
        }
        return mysqlTargetSb.toString();
    }
}

