/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterRegistry {
    private final Logger logger = LoggerFactory.getLogger(MasterRegistry.class);
    @Autowired
    private ZookeeperRegistryCenter zookeeperRegistryCenter;
    @Autowired
    private MasterConfig masterConfig;
    private ScheduledExecutorService heartBeatExecutor;
    private String startTime;

    @PostConstruct
    public void init() {
        this.startTime = DateUtils.dateToString((Date)new Date());
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
    }

    public void registry() {
        String address = NetUtils.getAddr((int)this.masterConfig.getListenPort());
        String localNodePath = this.getMasterPath();
        this.zookeeperRegistryCenter.getRegisterOperator().persistEphemeral(localNodePath, "");
        this.zookeeperRegistryCenter.getRegisterOperator().getZkClient().getConnectionStateListenable().addListener((client, newState) -> {
            if (newState == ConnectionState.LOST) {
                this.logger.error("master : {} connection lost from zookeeper", (Object)address);
            } else if (newState == ConnectionState.RECONNECTED) {
                this.logger.info("master : {} reconnected to zookeeper", (Object)address);
                this.zookeeperRegistryCenter.getRegisterOperator().persistEphemeral(localNodePath, "");
            } else if (newState == ConnectionState.SUSPENDED) {
                this.logger.warn("master : {} connection SUSPENDED ", (Object)address);
                this.zookeeperRegistryCenter.getRegisterOperator().persistEphemeral(localNodePath, "");
            }
        });
        int masterHeartbeatInterval = this.masterConfig.getMasterHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startTime, this.masterConfig.getMasterMaxCpuloadAvg(), this.masterConfig.getMasterReservedMemory(), Sets.newHashSet((Object[])new String[]{this.getMasterPath()}), "master", this.zookeeperRegistryCenter);
        this.heartBeatExecutor.scheduleAtFixedRate(heartBeatTask, masterHeartbeatInterval, masterHeartbeatInterval, TimeUnit.SECONDS);
        this.logger.info("master node : {} registry to ZK successfully with heartBeatInterval : {}s", (Object)address, (Object)masterHeartbeatInterval);
    }

    public void unRegistry() {
        String address = this.getLocalAddress();
        String localNodePath = this.getMasterPath();
        this.zookeeperRegistryCenter.getRegisterOperator().remove(localNodePath);
        this.logger.info("master node : {} unRegistry to ZK.", (Object)address);
        this.heartBeatExecutor.shutdown();
        this.logger.info("heartbeat executor shutdown");
    }

    public String getMasterPath() {
        String address = this.getLocalAddress();
        return this.zookeeperRegistryCenter.getMasterPath() + "/" + address;
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }

    public ZookeeperRegistryCenter getZookeeperRegistryCenter() {
        return this.zookeeperRegistryCenter;
    }
}

