/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceHdfsParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HdfsSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder hdfsSourceSb;
        block3: {
            hdfsSourceSb = new StringBuilder();
            try {
                SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHdfsParameter.class);
                if (null == sourceHdfsParameter) break block3;
                if (StringUtils.isNotEmpty((CharSequence)sourceHdfsParameter.getExportDir())) {
                    hdfsSourceSb.append(" ").append("--export-dir").append(" ").append(sourceHdfsParameter.getExportDir());
                    break block3;
                }
                throw new IllegalArgumentException("Sqoop hdfs export dir is null");
            }
            catch (Exception e) {
                logger.error(String.format("Sqoop hdfs source parmas build failed: [%s]", e.getMessage()));
            }
        }
        return hdfsSourceSb.toString();
    }
}

