/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import io.netty.channel.Channel;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dolphinscheduler.common.utils.IOUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.FastJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerRequestProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(LoggerRequestProcessor.class);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100));

    public void process(Channel channel, Command command) {
        this.logger.info("received command : {}", (Object)command);
        CommandType commandType = command.getType();
        switch (commandType) {
            case GET_LOG_BYTES_REQUEST: {
                GetLogBytesRequestCommand getLogRequest = (GetLogBytesRequestCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), GetLogBytesRequestCommand.class);
                byte[] bytes = this.getFileContentBytes(getLogRequest.getPath());
                GetLogBytesResponseCommand getLogResponse = new GetLogBytesResponseCommand(bytes);
                channel.writeAndFlush((Object)getLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case VIEW_WHOLE_LOG_REQUEST: {
                ViewLogRequestCommand viewLogRequest = (ViewLogRequestCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), ViewLogRequestCommand.class);
                String msg = this.readWholeFileContent(viewLogRequest.getPath());
                ViewLogResponseCommand viewLogResponse = new ViewLogResponseCommand(msg);
                channel.writeAndFlush((Object)viewLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case ROLL_VIEW_LOG_REQUEST: {
                RollViewLogRequestCommand rollViewLogRequest = (RollViewLogRequestCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), RollViewLogRequestCommand.class);
                List<String> lines = this.readPartFileContent(rollViewLogRequest.getPath(), rollViewLogRequest.getSkipLineNum(), rollViewLogRequest.getLimit());
                StringBuilder builder = new StringBuilder();
                for (String line : lines) {
                    builder.append(line + "\r\n");
                }
                RollViewLogResponseCommand rollViewLogRequestResponse = new RollViewLogResponseCommand(builder.toString());
                channel.writeAndFlush((Object)rollViewLogRequestResponse.convert2Command(command.getOpaque()));
                break;
            }
            case REMOVE_TAK_LOG_REQUEST: {
                RemoveTaskLogRequestCommand removeTaskLogRequest = (RemoveTaskLogRequestCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), RemoveTaskLogRequestCommand.class);
                String taskLogPath = removeTaskLogRequest.getPath();
                File taskLogFile = new File(taskLogPath);
                Boolean status = true;
                try {
                    if (taskLogFile.exists()) {
                        taskLogFile.delete();
                    }
                }
                catch (Exception e) {
                    status = false;
                }
                RemoveTaskLogResponseCommand removeTaskLogResponse = new RemoveTaskLogResponseCommand(status);
                channel.writeAndFlush((Object)removeTaskLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown commandType");
            }
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getFileContentBytes(String filePath) {
        byte[] byArray;
        FileInputStream in = null;
        ByteArrayOutputStream bos = null;
        try {
            int len;
            in = new FileInputStream(filePath);
            bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                this.logger.error("get file bytes error", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((Closeable)in);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)bos);
            IOUtils.closeQuietly((Closeable)in);
            return new byte[0];
        }
        IOUtils.closeQuietly((Closeable)bos);
        IOUtils.closeQuietly((Closeable)in);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readPartFileContent(String filePath, int skipLine, int limit) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));){
                List<String> list = stream.skip(skipLine).limit(limit).collect(Collectors.toList());
                return list;
            }
            catch (IOException e) {
                this.logger.error("read file error", (Throwable)e);
                return Collections.emptyList();
            }
        }
        this.logger.info("file path: {} not exists", (Object)filePath);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readWholeFileContent(String filePath) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            IOUtils.closeQuietly((Closeable)br);
            return string;
        }
        catch (IOException e) {
            this.logger.error("read file error", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        return "";
    }
}

