/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cache.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.TaskExecuteAckCommand;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.cache.TaskInstanceCacheManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceCacheManagerImpl
implements TaskInstanceCacheManager {
    private Map<Integer, TaskInstance> taskInstanceCache = new ConcurrentHashMap<Integer, TaskInstance>();
    @Autowired
    private ProcessService processService;

    @Override
    public TaskInstance getByTaskInstanceId(Integer taskInstanceId) {
        TaskInstance taskInstance = this.taskInstanceCache.get(taskInstanceId);
        if (taskInstance == null) {
            taskInstance = this.processService.findTaskInstanceById(taskInstanceId);
            this.taskInstanceCache.put(taskInstanceId, taskInstance);
        }
        return taskInstance;
    }

    @Override
    public void cacheTaskInstance(TaskExecutionContext taskExecutionContext) {
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setId(taskExecutionContext.getTaskInstanceId());
        taskInstance.setName(taskExecutionContext.getTaskName());
        taskInstance.setStartTime(taskExecutionContext.getStartTime());
        taskInstance.setTaskType(taskInstance.getTaskType());
        taskInstance.setExecutePath(taskInstance.getExecutePath());
        taskInstance.setTaskJson(taskInstance.getTaskJson());
        this.taskInstanceCache.put(taskExecutionContext.getTaskInstanceId(), taskInstance);
    }

    @Override
    public void cacheTaskInstance(TaskExecuteAckCommand taskAckCommand) {
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setState(ExecutionStatus.of((int)taskAckCommand.getStatus()));
        taskInstance.setStartTime(taskAckCommand.getStartTime());
        taskInstance.setHost(taskAckCommand.getHost());
        taskInstance.setExecutePath(taskAckCommand.getExecutePath());
        taskInstance.setLogPath(taskAckCommand.getLogPath());
        this.taskInstanceCache.put(taskAckCommand.getTaskInstanceId(), taskInstance);
    }

    @Override
    public void cacheTaskInstance(TaskExecuteResponseCommand taskExecuteResponseCommand) {
        TaskInstance taskInstance = this.getByTaskInstanceId(taskExecuteResponseCommand.getTaskInstanceId());
        taskInstance.setState(ExecutionStatus.of((int)taskExecuteResponseCommand.getStatus()));
        taskInstance.setEndTime(taskExecuteResponseCommand.getEndTime());
    }

    @Override
    public void removeByTaskInstanceId(Integer taskInstanceId) {
        this.taskInstanceCache.remove(taskInstanceId);
    }
}

