/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.utils.ArgsUtils;

public class FlinkArgsUtils {
    private static final String LOCAL_DEPLOY_MODE = "local";
    private static final String FLINK_VERSION_BEFORE_1_10 = "<1.10";

    private FlinkArgsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> buildArgs(FlinkParameters param) {
        String mainArgs;
        int parallelism;
        ArrayList<String> args = new ArrayList<String>();
        String deployMode = "cluster";
        String tmpDeployMode = param.getDeployMode();
        if (StringUtils.isNotEmpty((CharSequence)tmpDeployMode)) {
            deployMode = tmpDeployMode;
        }
        String others = param.getOthers();
        if (!LOCAL_DEPLOY_MODE.equals(deployMode)) {
            String queue;
            String taskManagerMemory;
            String jobManagerMemory;
            int taskManager;
            String flinkVersion;
            String appName;
            args.add("-m");
            args.add("yarn-cluster");
            int slot = param.getSlot();
            if (slot > 0) {
                args.add("-ys");
                args.add(String.format("%d", slot));
            }
            if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
                args.add("-ynm");
                args.add(ArgsUtils.escape(appName));
            }
            if (((flinkVersion = param.getFlinkVersion()) == null || FLINK_VERSION_BEFORE_1_10.equals(flinkVersion)) && (taskManager = param.getTaskManager()) > 0) {
                args.add("-yn");
                args.add(String.format("%d", taskManager));
            }
            if (StringUtils.isNotEmpty((CharSequence)(jobManagerMemory = param.getJobManagerMemory()))) {
                args.add("-yjm");
                args.add(jobManagerMemory);
            }
            if (StringUtils.isNotEmpty((CharSequence)(taskManagerMemory = param.getTaskManagerMemory()))) {
                args.add("-ytm");
                args.add(taskManagerMemory);
            }
            if ((StringUtils.isEmpty((CharSequence)others) || !others.contains("-yqu")) && StringUtils.isNotEmpty((CharSequence)(queue = param.getQueue()))) {
                args.add("-yqu");
                args.add(queue);
            }
        }
        if ((parallelism = param.getParallelism()) > 0) {
            args.add("-p");
            args.add(String.format("%d", parallelism));
        }
        args.add("-sae");
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (ProgramType.PYTHON == programType) {
            args.add("-py");
        } else if (programType != null && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("-c");
            args.add(param.getMainClass());
        }
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null) {
            args.add(mainJar.getRes());
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }
}

