/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Pattern MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
    private static final Pattern LINUXPATTERN = Pattern.compile("(\\d+)");
    private static final String LOCAL_PROCESS_EXEC = "jdk.lang.Process.allowAmbiguousCommands";
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_LEGACY = 2;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t'}};

    public static String buildCommandStr(List<String> commandList) throws IOException {
        String cmdstr;
        String[] cmd = commandList.toArray(new String[0]);
        SecurityManager security = System.getSecurityManager();
        boolean allowAmbiguousCommands = ProcessUtils.isAllowAmbiguousCommands(security);
        if (allowAmbiguousCommands) {
            String executablePath = new File(cmd[0]).getPath();
            if (ProcessUtils.needsEscaping(2, executablePath)) {
                executablePath = ProcessUtils.quoteString(executablePath);
            }
            cmdstr = ProcessUtils.createCommandLine(2, executablePath, cmd);
        } else {
            String executablePath;
            block6: {
                try {
                    executablePath = ProcessUtils.getExecutablePath(cmd[0]);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder join = new StringBuilder();
                    for (String s : cmd) {
                        join.append(s).append(' ');
                    }
                    cmd = ProcessUtils.getTokensFromCommand(join.toString());
                    executablePath = ProcessUtils.getExecutablePath(cmd[0]);
                    if (security == null) break block6;
                    security.checkExec(executablePath);
                }
            }
            cmdstr = ProcessUtils.createCommandLine(ProcessUtils.isShellFile(executablePath) ? 0 : 1, ProcessUtils.quoteString(executablePath), cmd);
        }
        return cmdstr;
    }

    private static boolean isAllowAmbiguousCommands(SecurityManager security) {
        boolean allowAmbiguousCommands = false;
        if (security == null) {
            allowAmbiguousCommands = true;
            String value = System.getProperty(LOCAL_PROCESS_EXEC);
            if (value != null) {
                allowAmbiguousCommands = !"false".equalsIgnoreCase(value);
            }
        }
        return allowAmbiguousCommands;
    }

    private static String getExecutablePath(String path) throws IOException {
        boolean pathIsQuoted = ProcessUtils.isQuoted(true, path, "Executable name has embedded quote, split the arguments");
        File fileToRun = new File(pathIsQuoted ? path.substring(1, path.length() - 1) : path);
        return fileToRun.getPath();
    }

    private static boolean isShellFile(String executablePath) {
        String upPath = executablePath.toUpperCase();
        return upPath.endsWith(".CMD") || upPath.endsWith(".BAT");
    }

    private static String quoteString(String arg) {
        StringBuilder argbuf = new StringBuilder(arg.length() + 2);
        return argbuf.append('\"').append(arg).append('\"').toString();
    }

    private static String[] getTokensFromCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>(8);
        Matcher regexMatcher = LazyPattern.PATTERN.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[0]);
    }

    private static String createCommandLine(int verificationType, String executablePath, String[] cmd) {
        StringBuilder cmdbuf = new StringBuilder(80);
        cmdbuf.append(executablePath);
        for (int i = 1; i < cmd.length; ++i) {
            cmdbuf.append(' ');
            String s = cmd[i];
            if (ProcessUtils.needsEscaping(verificationType, s)) {
                cmdbuf.append('\"').append(s);
                if (verificationType != 0 && s.endsWith("\\")) {
                    cmdbuf.append('\\');
                }
                cmdbuf.append('\"');
                continue;
            }
            cmdbuf.append(s);
        }
        return cmdbuf.toString();
    }

    private static boolean isQuoted(boolean noQuotesInside, String arg, String errorMessage) {
        int lastPos = arg.length() - 1;
        if (lastPos >= 1 && arg.charAt(0) == '\"' && arg.charAt(lastPos) == '\"') {
            if (noQuotesInside && arg.indexOf(34, 1) != lastPos) {
                throw new IllegalArgumentException(errorMessage);
            }
            return true;
        }
        if (noQuotesInside && arg.indexOf(34) >= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return false;
    }

    private static boolean needsEscaping(int verificationType, String arg) {
        boolean argIsQuoted = ProcessUtils.isQuoted(verificationType == 0, arg, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!argIsQuoted) {
            char[] testEscape;
            for (char c : testEscape = ESCAPE_VERIFICATION[verificationType]) {
                if (arg.indexOf(c) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void cancelApplication(List<String> appIds, Logger logger, String tenantCode, String executePath) {
        if (CollectionUtils.isNotEmpty(appIds)) {
            for (String appId : appIds) {
                try {
                    ExecutionStatus applicationStatus = HadoopUtils.getInstance().getApplicationStatus(appId);
                    if (applicationStatus.typeIsFinished()) continue;
                    String commandFile = String.format("%s/%s.kill", executePath, appId);
                    String cmd = "yarn application -kill " + appId;
                    ProcessUtils.execYarnKillCommand(logger, tenantCode, appId, commandFile, cmd);
                }
                catch (Exception e) {
                    logger.error(String.format("Get yarn application app id [%s] status failed: [%s]", appId, e.getMessage()));
                }
            }
        }
    }

    private static void execYarnKillCommand(Logger logger, String tenantCode, String appId, String commandFile, String cmd) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("#!/bin/sh\n");
            sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
            sb.append("cd $BASEDIR\n");
            if (CommonUtils.getSystemEnvPath() != null) {
                sb.append("source ").append(CommonUtils.getSystemEnvPath()).append("\n");
            }
            sb.append("\n\n");
            sb.append(cmd);
            File f = new File(commandFile);
            if (!f.exists()) {
                FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
            }
            String runCmd = String.format("%s %s", "sh", commandFile);
            if (StringUtils.isNotEmpty((CharSequence)tenantCode)) {
                runCmd = "sudo -u " + tenantCode + " " + runCmd;
            }
            logger.info("kill cmd:{}", (Object)runCmd);
            OSUtils.exeCmd((String)runCmd);
        }
        catch (Exception e) {
            logger.error(String.format("Kill yarn application app id [%s] failed: [%s]", appId, e.getMessage()));
        }
    }

    public static void kill(TaskExecutionContext taskExecutionContext) {
        try {
            int processId = taskExecutionContext.getProcessId();
            if (processId == 0) {
                logger.error("process kill failed, process id :{}, task id:{}", (Object)processId, (Object)taskExecutionContext.getTaskInstanceId());
                return;
            }
            String pidsStr = ProcessUtils.getPidsStr(processId);
            if (StringUtils.isNotEmpty((CharSequence)pidsStr)) {
                String cmd = String.format("sudo kill -9 %s", pidsStr);
                logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
                OSUtils.exeCmd((String)cmd);
            }
        }
        catch (Exception e) {
            logger.error("kill task failed", (Throwable)e);
        }
        ProcessUtils.killYarnJob(taskExecutionContext);
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        List<String> pidList = new ArrayList<String>();
        Matcher mat = null;
        if (OSUtils.isMacOS()) {
            pids = OSUtils.exeCmd((String)String.format("%s -sp %d", "pstree", processId));
            if (null != pids) {
                mat = MACPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId));
            mat = LINUXPATTERN.matcher(pids);
        }
        if (null != mat) {
            while (mat.find()) {
                pidList.add(mat.group(1));
            }
        }
        if (!pidList.isEmpty()) {
            pidList = pidList.subList(1, pidList.size());
        }
        return String.join((CharSequence)" ", pidList).trim();
    }

    public static List<String> killYarnJob(TaskExecutionContext taskExecutionContext) {
        try {
            String log;
            Thread.sleep(1000L);
            try (LogClientService logClient = null;){
                logClient = new LogClientService();
                log = logClient.viewLog(Host.of((String)taskExecutionContext.getHost()).getIp(), 50051, taskExecutionContext.getLogPath());
            }
            if (StringUtils.isNotEmpty((CharSequence)log)) {
                if (StringUtils.isEmpty((CharSequence)taskExecutionContext.getExecutePath())) {
                    taskExecutionContext.setExecutePath(FileUtils.getProcessExecDir((int)taskExecutionContext.getProjectId(), (int)taskExecutionContext.getProcessDefineId(), (int)taskExecutionContext.getProcessInstanceId(), (int)taskExecutionContext.getTaskInstanceId()));
                }
                FileUtils.createWorkDir((String)taskExecutionContext.getExecutePath());
                List appIds = LoggerUtils.getAppIds((String)log, (Logger)logger);
                if (CollectionUtils.isNotEmpty((Collection)appIds)) {
                    ProcessUtils.cancelApplication(appIds, logger, taskExecutionContext.getTenantCode(), taskExecutionContext.getExecutePath());
                    return appIds;
                }
            }
        }
        catch (Exception e) {
            logger.error("kill yarn job failure", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

