/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.utils.ArgsUtils;

public class SparkArgsUtils {
    private static final String SPARK_CLUSTER = "cluster";
    private static final String SPARK_LOCAL = "local";
    private static final String SPARK_ON_YARN = "yarn";

    private SparkArgsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> buildArgs(SparkParameters param) {
        String mainArgs;
        ResourceInfo mainJar;
        String queue;
        String appName;
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        args.add("--master");
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)param.getDeployMode()) ? param.getDeployMode() : SPARK_CLUSTER;
        if (!SPARK_LOCAL.equals(deployMode)) {
            args.add(SPARK_ON_YARN);
            args.add("--deploy-mode");
        }
        args.add(deployMode);
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("--class");
            args.add(mainClass);
        }
        if ((driverCores = param.getDriverCores()) > 0) {
            args.add("--driver-cores");
            args.add(String.format("%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = param.getDriverMemory()))) {
            args.add("--driver-memory");
            args.add(driverMemory);
        }
        if ((numExecutors = param.getNumExecutors()) > 0) {
            args.add("--num-executors");
            args.add(String.format("%d", numExecutors));
        }
        if ((executorCores = param.getExecutorCores()) > 0) {
            args.add("--executor-cores");
            args.add(String.format("%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = param.getExecutorMemory()))) {
            args.add("--executor-memory");
            args.add(executorMemory);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add("--name");
            args.add(ArgsUtils.escape(appName));
        }
        String others = param.getOthers();
        if (!SPARK_LOCAL.equals(deployMode) && (StringUtils.isEmpty((CharSequence)others) || !others.contains("--queue")) && StringUtils.isNotEmpty((CharSequence)(queue = param.getQueue()))) {
            args.add("--queue");
            args.add(queue);
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if ((mainJar = param.getMainJar()) != null) {
            args.add(mainJar.getRes());
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }
}

