/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractCommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PythonCommandExecutor.class);
    public static final String PYTHON = "python";
    private static final Pattern PYTHON_PATH_PATTERN = Pattern.compile("/bin/python[\\d.]*$");

    public PythonCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskExecutionContext taskExecutionContext, Logger logger) {
        super(logHandler, taskExecutionContext, logger);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/py_%s.command", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId());
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        logger.info("tenantCode :{}, task dir:{}", (Object)this.taskExecutionContext.getTenantCode(), (Object)this.taskExecutionContext.getExecutePath());
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            logger.info("generate command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#-*- encoding=utf8 -*-\n");
            sb.append("\n\n");
            sb.append(execCommand);
            logger.info(sb.toString());
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    @Override
    protected List<String> commandOptions() {
        return Collections.singletonList("-u");
    }

    @Override
    protected String commandInterpreter() {
        String pythonHome = PythonCommandExecutor.getPythonHome(this.taskExecutionContext.getEnvFile());
        return PythonCommandExecutor.getPythonCommand(pythonHome);
    }

    public static String getPythonCommand(String pythonHome) {
        if (StringUtils.isEmpty((CharSequence)pythonHome)) {
            return PYTHON;
        }
        File file = new File(pythonHome);
        if (file.exists() && file.isFile()) {
            return pythonHome;
        }
        if (PYTHON_PATH_PATTERN.matcher(pythonHome).find()) {
            return pythonHome;
        }
        return Paths.get(pythonHome, "/bin/python").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPythonHome(String envPath) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String result;
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(envPath)));
            while ((line = br.readLine()) != null) {
                if (!line.contains("PYTHON_HOME")) continue;
                sb.append(line);
                break;
            }
            if (StringUtils.isEmpty((CharSequence)(result = sb.toString()))) {
                String string = null;
                return string;
            }
            String[] arrs = result.split("=");
            if (arrs.length == 2) {
                String string = arrs[1];
                return string;
            }
        }
        catch (IOException e) {
            logger.error("read file failure", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

