/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceHiveParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HiveSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder hiveSourceSb = new StringBuilder();
        try {
            SourceHiveParameter sourceHiveParameter = (SourceHiveParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHiveParameter.class);
            if (null != sourceHiveParameter) {
                if (StringUtils.isNotEmpty((CharSequence)sourceHiveParameter.getHiveDatabase())) {
                    hiveSourceSb.append(" ").append("--hcatalog-database").append(" ").append(sourceHiveParameter.getHiveDatabase());
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceHiveParameter.getHiveTable())) {
                    hiveSourceSb.append(" ").append("--hcatalog-table").append(" ").append(sourceHiveParameter.getHiveTable());
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceHiveParameter.getHivePartitionKey()) && StringUtils.isNotEmpty((CharSequence)sourceHiveParameter.getHivePartitionValue())) {
                    hiveSourceSb.append(" ").append("--hcatalog-partition-keys").append(" ").append(sourceHiveParameter.getHivePartitionKey()).append(" ").append("--hcatalog-partition-values").append(" ").append(sourceHiveParameter.getHivePartitionValue());
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop hive source params build failed: [%s]", e.getMessage()));
        }
        return hiveSourceSb.toString();
    }
}

