/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.apache.dolphinscheduler.service.zk.AbstractListener;
import org.apache.dolphinscheduler.service.zk.AbstractZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class ServerNodeManager
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ServerNodeManager.class);
    private final Lock masterLock = new ReentrantLock();
    private final Lock workerGroupLock = new ReentrantLock();
    private final Lock workerNodeInfoLock = new ReentrantLock();
    private final ConcurrentHashMap<String, Set<String>> workerGroupNodes = new ConcurrentHashMap();
    private final Set<String> masterNodes = new HashSet<String>();
    private final Map<String, String> workerNodeInfo = new HashMap<String, String>();
    private ScheduledExecutorService executorService;
    @Autowired
    private ZKClient zkClient;
    @Autowired
    private ZookeeperRegistryCenter registryCenter;
    @Autowired
    private WorkerGroupMapper workerGroupMapper;
    @Autowired
    private AlertDao alertDao;

    public void afterPropertiesSet() throws Exception {
        this.load();
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ServerNodeManagerExecutor"));
        this.executorService.scheduleWithFixedDelay(new WorkerNodeInfoAndGroupDbSyncTask(), 0L, 10L, TimeUnit.SECONDS);
        this.registryCenter.getRegisterOperator().registerListener((AbstractListener)new MasterNodeListener(Integer.MAX_VALUE));
        this.registryCenter.getRegisterOperator().registerListener((AbstractListener)new WorkerGroupNodeListener(Integer.MAX_VALUE));
    }

    private void load() {
        Set<String> initMasterNodes = this.registryCenter.getMasterNodesDirectly();
        this.syncMasterNodes(initMasterNodes);
        Set<String> workerGroups = this.registryCenter.getWorkerGroupDirectly();
        for (String workerGroup : workerGroups) {
            this.syncWorkerGroupNodes(workerGroup, this.registryCenter.getWorkerGroupNodesDirectly(workerGroup));
        }
    }

    public Set<String> getMasterNodes() {
        this.masterLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.masterNodes);
            return set;
        }
        finally {
            this.masterLock.unlock();
        }
    }

    private void syncMasterNodes(Set<String> nodes) {
        this.masterLock.lock();
        try {
            this.masterNodes.clear();
            this.masterNodes.addAll(nodes);
        }
        finally {
            this.masterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWorkerGroupNodes(String workerGroup, Set<String> nodes) {
        this.workerGroupLock.lock();
        try {
            workerGroup = workerGroup.toLowerCase();
            Set workerNodes = this.workerGroupNodes.getOrDefault(workerGroup, new HashSet());
            workerNodes.clear();
            workerNodes.addAll(nodes);
            this.workerGroupNodes.put(workerGroup, workerNodes);
        }
        finally {
            this.workerGroupLock.unlock();
        }
    }

    public Map<String, Set<String>> getWorkerGroupNodes() {
        return Collections.unmodifiableMap(this.workerGroupNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWorkerGroupNodes(String workerGroup) {
        this.workerGroupLock.lock();
        try {
            Set<String> nodes;
            if (StringUtils.isEmpty((CharSequence)workerGroup)) {
                workerGroup = "default";
            }
            if (CollectionUtils.isNotEmpty(nodes = this.workerGroupNodes.get(workerGroup = workerGroup.toLowerCase()))) {
                Set<String> set = Collections.unmodifiableSet(nodes);
                return set;
            }
            Set<String> set = nodes;
            return set;
        }
        finally {
            this.workerGroupLock.unlock();
        }
    }

    public Map<String, String> getWorkerNodeInfo() {
        return Collections.unmodifiableMap(this.workerNodeInfo);
    }

    public String getWorkerNodeInfo(String workerNode) {
        this.workerNodeInfoLock.lock();
        try {
            String string = this.workerNodeInfo.getOrDefault(workerNode, null);
            return string;
        }
        finally {
            this.workerNodeInfoLock.unlock();
        }
    }

    private void syncWorkerNodeInfo(Map<String, String> newWorkerNodeInfo) {
        this.workerNodeInfoLock.lock();
        try {
            this.workerNodeInfo.clear();
            this.workerNodeInfo.putAll(newWorkerNodeInfo);
        }
        finally {
            this.workerNodeInfoLock.unlock();
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
        this.registryCenter.close();
    }

    class MasterNodeListener
    extends AbstractListener {
        public MasterNodeListener(int order) {
            super(order);
        }

        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ServerNodeManager.this.registryCenter.isMasterPath(path)) {
                try {
                    if (event.getType() == TreeCacheEvent.Type.NODE_ADDED) {
                        ServerNodeManager.this.logger.info("master node : {} added.", (Object)path);
                        Set<String> currentNodes = ServerNodeManager.this.registryCenter.getMasterNodesDirectly();
                        ServerNodeManager.this.syncMasterNodes(currentNodes);
                    } else if (event.getType() == TreeCacheEvent.Type.NODE_REMOVED) {
                        ServerNodeManager.this.logger.info("master node : {} down.", (Object)path);
                        Set<String> currentNodes = ServerNodeManager.this.registryCenter.getMasterNodesDirectly();
                        ServerNodeManager.this.syncMasterNodes(currentNodes);
                        ServerNodeManager.this.alertDao.sendServerStopedAlert(1, path, "MASTER");
                    }
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("MasterNodeListener capture data change and get data failed.", (Throwable)ex);
                }
            }
        }
    }

    class WorkerGroupNodeListener
    extends AbstractListener {
        public WorkerGroupNodeListener(int order) {
            super(order);
        }

        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ServerNodeManager.this.registryCenter.isWorkerPath(path)) {
                try {
                    if (event.getType() == TreeCacheEvent.Type.NODE_ADDED) {
                        ServerNodeManager.this.logger.info("worker group node : {} added.", (Object)path);
                        String group = this.parseGroup(path);
                        Set<String> currentNodes = ServerNodeManager.this.registryCenter.getWorkerGroupNodesDirectly(group);
                        ServerNodeManager.this.logger.info("currentNodes : {}", currentNodes);
                        ServerNodeManager.this.syncWorkerGroupNodes(group, currentNodes);
                    } else if (event.getType() == TreeCacheEvent.Type.NODE_REMOVED) {
                        ServerNodeManager.this.logger.info("worker group node : {} down.", (Object)path);
                        String group = this.parseGroup(path);
                        Set<String> currentNodes = ServerNodeManager.this.registryCenter.getWorkerGroupNodesDirectly(group);
                        ServerNodeManager.this.syncWorkerGroupNodes(group, currentNodes);
                        ServerNodeManager.this.alertDao.sendServerStopedAlert(1, path, "WORKER");
                    }
                }
                catch (IllegalArgumentException ex) {
                    ServerNodeManager.this.logger.warn(ex.getMessage());
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("WorkerGroupListener capture data change and get data failed", (Throwable)ex);
                }
            }
        }

        private String parseGroup(String path) {
            String[] parts = path.split("/");
            if (parts.length < 6) {
                throw new IllegalArgumentException(String.format("worker group path : %s is not valid, ignore", path));
            }
            return parts[parts.length - 2];
        }
    }

    class WorkerNodeInfoAndGroupDbSyncTask
    implements Runnable {
        WorkerNodeInfoAndGroupDbSyncTask() {
        }

        @Override
        public void run() {
            Map newWorkerNodeInfo = ServerNodeManager.this.zkClient.getServerMaps(ZKNodeType.WORKER, true);
            ServerNodeManager.this.syncWorkerNodeInfo(newWorkerNodeInfo);
            List workerGroupList = ServerNodeManager.this.workerGroupMapper.queryAllWorkerGroup();
            if (CollectionUtils.isNotEmpty((Collection)workerGroupList)) {
                for (WorkerGroup wg : workerGroupList) {
                    String[] addrs;
                    String workerGroup = wg.getName();
                    HashSet<String> nodes = new HashSet<String>();
                    for (String addr : addrs = wg.getAddrList().split(",")) {
                        if (!newWorkerNodeInfo.containsKey(addr)) continue;
                        nodes.add(addr);
                    }
                    if (nodes.isEmpty()) continue;
                    ServerNodeManager.this.syncWorkerGroupNodes(workerGroup, nodes);
                }
            }
        }
    }

    @Component
    static class ZKClient
    extends AbstractZKClient {
        ZKClient() {
        }
    }
}

