/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.registry;

import java.util.Date;
import java.util.Set;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HeartBeatTask.class);
    private String startTime;
    private double reservedMemory;
    private double maxCpuloadAvg;
    private Set<String> heartBeatPaths;
    private String serverType;
    private ZookeeperRegistryCenter zookeeperRegistryCenter;
    protected IStoppable stoppable = null;

    public HeartBeatTask(String startTime, double maxCpuloadAvg, double reservedMemory, Set<String> heartBeatPaths, String serverType, ZookeeperRegistryCenter zookeeperRegistryCenter) {
        this.startTime = startTime;
        this.maxCpuloadAvg = maxCpuloadAvg;
        this.reservedMemory = reservedMemory;
        this.heartBeatPaths = heartBeatPaths;
        this.serverType = serverType;
        this.zookeeperRegistryCenter = zookeeperRegistryCenter;
    }

    @Override
    public void run() {
        try {
            for (String heartBeatPath : this.heartBeatPaths) {
                if (!this.zookeeperRegistryCenter.checkIsDeadServer(heartBeatPath, this.serverType)) continue;
                this.zookeeperRegistryCenter.getStoppable().stop("i was judged to death, release resources and stop myself");
                return;
            }
            double loadAverage = OSUtils.loadAverage();
            double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
            int status = 0;
            if (loadAverage > this.maxCpuloadAvg || availablePhysicalMemorySize < this.reservedMemory) {
                this.logger.warn("current cpu load average {} is too high or available memory {}G is too low, under max.cpuload.avg={} and reserved.memory={}G", new Object[]{loadAverage, availablePhysicalMemorySize, this.maxCpuloadAvg, this.reservedMemory});
                status = 1;
            }
            StringBuilder builder = new StringBuilder(100);
            builder.append(OSUtils.cpuUsage()).append(",");
            builder.append(OSUtils.memoryUsage()).append(",");
            builder.append(OSUtils.loadAverage()).append(",");
            builder.append(OSUtils.availablePhysicalMemorySize()).append(",");
            builder.append(this.maxCpuloadAvg).append(",");
            builder.append(this.reservedMemory).append(",");
            builder.append(this.startTime).append(",");
            builder.append(DateUtils.dateToString((Date)new Date())).append(",");
            builder.append(status).append(",");
            builder.append(OSUtils.getProcessID());
            for (String heartBeatPath : this.heartBeatPaths) {
                this.zookeeperRegistryCenter.getRegisterOperator().update(heartBeatPath, builder.toString());
            }
        }
        catch (Throwable ex) {
            this.logger.error("error write heartbeat info", ex);
        }
    }

    public void setStoppable(IStoppable serverStoppable) {
        this.stoppable = serverStoppable;
    }
}

