/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.registry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.service.zk.RegisterOperator;
import org.apache.dolphinscheduler.service.zk.ZookeeperConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZookeeperRegistryCenter
implements InitializingBean {
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    @Autowired
    protected RegisterOperator registerOperator;
    @Autowired
    private ZookeeperConfig zookeeperConfig;
    public String NODES;
    public String MASTER_PATH;
    public String WORKER_PATH;
    public final String EMPTY = "";
    private IStoppable stoppable;

    public void afterPropertiesSet() throws Exception {
        this.NODES = this.zookeeperConfig.getDsRoot() + "/nodes";
        this.MASTER_PATH = this.NODES + "/master";
        this.WORKER_PATH = this.NODES + "/worker";
        this.init();
    }

    public void init() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.initNodes();
        }
    }

    private void initNodes() {
        this.registerOperator.persist(this.MASTER_PATH, "");
        this.registerOperator.persist(this.WORKER_PATH, "");
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false) && this.registerOperator != null) {
            this.registerOperator.close();
        }
    }

    public String getMasterPath() {
        return this.MASTER_PATH;
    }

    public String getWorkerPath() {
        return this.WORKER_PATH;
    }

    public Set<String> getMasterNodesDirectly() {
        List<String> masters = this.getChildrenKeys(this.MASTER_PATH);
        return new HashSet<String>(masters);
    }

    public Set<String> getWorkerNodesDirectly() {
        List<String> workers = this.getChildrenKeys(this.WORKER_PATH);
        return new HashSet<String>(workers);
    }

    public Set<String> getWorkerGroupDirectly() {
        List<String> workers = this.getChildrenKeys(this.getWorkerPath());
        return new HashSet<String>(workers);
    }

    public Set<String> getWorkerGroupNodesDirectly(String workerGroup) {
        List<String> workers = this.getChildrenKeys(this.getWorkerGroupPath(workerGroup));
        return new HashSet<String>(workers);
    }

    public boolean isWorkerPath(String path) {
        return path != null && path.contains(this.WORKER_PATH);
    }

    public boolean isMasterPath(String path) {
        return path != null && path.contains(this.MASTER_PATH);
    }

    public String getWorkerGroupPath(String workerGroup) {
        return this.WORKER_PATH + "/" + workerGroup;
    }

    public List<String> getChildrenKeys(String key) {
        return this.registerOperator.getChildrenKeys(key);
    }

    public String getDeadZNodeParentPath() {
        return this.registerOperator.getZookeeperConfig().getDsRoot() + "/dead-servers";
    }

    public void setStoppable(IStoppable stoppable) {
        this.stoppable = stoppable;
    }

    public IStoppable getStoppable() {
        return this.stoppable;
    }

    protected boolean checkIsDeadServer(String zNode, String serverType) throws Exception {
        String[] zNodesPath = zNode.split("\\/");
        String ipSeqNo = zNodesPath[zNodesPath.length - 1];
        String deadServerPath = this.getDeadZNodeParentPath() + "/" + serverType + "_" + ipSeqNo;
        return !this.registerOperator.isExisted(zNode) || this.registerOperator.isExisted(deadServerPath);
    }

    public RegisterOperator getRegisterOperator() {
        return this.registerOperator;
    }
}

