/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;

public class ParamUtils {
    public static Map<String, Property> convert(Map<String, Property> globalParams, Map<String, String> globalParamsMap, Map<String, Property> localParams, CommandType commandType, Date scheduleTime) {
        if (globalParams == null && localParams == null) {
            return null;
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime);
        if (globalParamsMap != null) {
            timeParams.putAll(globalParamsMap);
        }
        if (globalParams != null && localParams != null) {
            globalParams.putAll(localParams);
        } else if (globalParams == null && localParams != null) {
            globalParams = localParams;
        }
        for (Map.Entry<String, Property> en : globalParams.entrySet()) {
            Property property = en.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)property.getValue()) || !property.getValue().startsWith("$")) continue;
            String val = property.getValue();
            val = ParameterUtils.convertParameterPlaceholders((String)val, (Map)timeParams);
            property.setValue(val);
        }
        return globalParams;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        if (paramsMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    public static Map<String, Property> getUserDefParamsMap(Map<String, String> definedParams) {
        if (definedParams != null) {
            HashMap<String, Property> userDefParamsMaps = new HashMap<String, Property>();
            for (Map.Entry<String, String> en : definedParams.entrySet()) {
                Property property = new Property(en.getKey(), Direct.IN, DataType.VARCHAR, en.getValue());
                userDefParamsMaps.put(property.getProp(), property);
            }
            return userDefParamsMaps;
        }
        return null;
    }
}

