/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.cache.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.cache.TaskExecutionContextCacheManager;
import org.springframework.stereotype.Service;

@Service
public class TaskExecutionContextCacheManagerImpl
implements TaskExecutionContextCacheManager {
    private Map<Integer, TaskExecutionContext> taskExecutionContextCache = new ConcurrentHashMap<Integer, TaskExecutionContext>();

    @Override
    public TaskExecutionContext getByTaskInstanceId(Integer taskInstanceId) {
        return this.taskExecutionContextCache.get(taskInstanceId);
    }

    @Override
    public void cacheTaskExecutionContext(TaskExecutionContext taskExecutionContext) {
        this.taskExecutionContextCache.put(taskExecutionContext.getTaskInstanceId(), taskExecutionContext);
    }

    @Override
    public void removeByTaskInstanceId(Integer taskInstanceId) {
        this.taskExecutionContextCache.remove(taskInstanceId);
    }

    @Override
    public boolean updateTaskExecutionContext(TaskExecutionContext taskExecutionContext) {
        this.taskExecutionContextCache.computeIfPresent(taskExecutionContext.getTaskInstanceId(), (k, v) -> taskExecutionContext);
        return this.taskExecutionContextCache.containsKey(taskExecutionContext.getTaskInstanceId());
    }
}

