/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonHostManager
implements HostManager {
    @Autowired
    protected ServerNodeManager serverNodeManager;

    @Override
    public Host select(ExecutionContext context) {
        List<Host> candidates = null;
        String workerGroup = context.getWorkerGroup();
        ExecutorType executorType = context.getExecutorType();
        switch (executorType) {
            case WORKER: {
                candidates = this.getWorkerCandidates(workerGroup);
                break;
            }
            case CLIENT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid executorType : " + (Object)((Object)executorType));
            }
        }
        if (CollectionUtils.isEmpty(candidates)) {
            return new Host();
        }
        return this.select(candidates);
    }

    protected abstract Host select(Collection<Host> var1);

    protected List<Host> getWorkerCandidates(String workerGroup) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        Set<String> nodes = this.serverNodeManager.getWorkerGroupNodes(workerGroup);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (String node : nodes) {
                hosts.add(Host.of((String)node));
            }
        }
        return hosts;
    }
}

