/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.Preconditions;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.ChannelUtils;
import org.apache.dolphinscheduler.remote.utils.FastJsonSerializer;
import org.apache.dolphinscheduler.server.master.cache.TaskInstanceCacheManager;
import org.apache.dolphinscheduler.server.master.cache.impl.TaskInstanceCacheManagerImpl;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskAckProcessor.class);
    private final TaskResponseService taskResponseService = (TaskResponseService)SpringApplicationContext.getBean(TaskResponseService.class);
    private final TaskInstanceCacheManager taskInstanceCacheManager = (TaskInstanceCacheManager)SpringApplicationContext.getBean(TaskInstanceCacheManagerImpl.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteAckCommand taskAckCommand = (TaskExecuteAckCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), TaskExecuteAckCommand.class);
        this.logger.info("taskAckCommand : {}", (Object)taskAckCommand);
        this.taskInstanceCacheManager.cacheTaskInstance(taskAckCommand);
        String workerAddress = ChannelUtils.toAddress((Channel)channel).getAddress();
        ExecutionStatus ackStatus = ExecutionStatus.of((int)taskAckCommand.getStatus());
        TaskResponseEvent taskResponseEvent = TaskResponseEvent.newAck(ackStatus, taskAckCommand.getStartTime(), workerAddress, taskAckCommand.getExecutePath(), taskAckCommand.getLogPath(), taskAckCommand.getTaskInstanceId(), channel);
        this.taskResponseService.addResponse(taskResponseEvent);
    }
}

