/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.sift.SiftingAppender;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.log.TaskLogDiscriminator;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBaseTaskExecThread
implements Callable<Boolean> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    protected AlertDao alertDao = (AlertDao)SpringApplicationContext.getBean(AlertDao.class);
    protected ProcessInstance processInstance;
    protected TaskInstance taskInstance;
    protected boolean cancel = false;
    protected MasterConfig masterConfig;
    private TaskPriorityQueue taskUpdateQueue;
    protected boolean checkTimeoutFlag = false;
    protected TaskTimeoutParameter taskTimeoutParameter;

    public MasterBaseTaskExecThread(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
        this.masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
        this.taskUpdateQueue = (TaskPriorityQueue)SpringApplicationContext.getBean(TaskPriorityQueueImpl.class);
        this.initTaskParams();
    }

    private void initTaskParams() {
        this.initTimeoutParams();
    }

    private void initTimeoutParams() {
        String taskJson = this.taskInstance.getTaskJson();
        TaskNode taskNode = (TaskNode)JSON.parseObject((String)taskJson, TaskNode.class);
        this.taskTimeoutParameter = taskNode.getTaskTimeoutParameter();
        if (this.taskTimeoutParameter.getEnable()) {
            this.checkTimeoutFlag = true;
        }
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void kill() {
        this.cancel = true;
    }

    protected TaskInstance submit() {
        Integer commitRetryTimes = this.masterConfig.getMasterTaskCommitRetryTimes();
        Integer commitRetryInterval = this.masterConfig.getMasterTaskCommitInterval();
        boolean submitDB = false;
        boolean submitTask = false;
        TaskInstance task = null;
        for (int retryTimes = 1; retryTimes <= commitRetryTimes; ++retryTimes) {
            try {
                if (!submitDB && (task = this.processService.submitTask(this.taskInstance)) != null && task.getId() != 0) {
                    submitDB = true;
                }
                if (submitDB && !submitTask) {
                    submitTask = this.dispatchTask(task);
                }
                if (submitDB && submitTask) {
                    return task;
                }
                if (!submitDB) {
                    this.logger.error("task commit to db failed , taskId {} has already retry {} times, please check the database", (Object)this.taskInstance.getId(), (Object)retryTimes);
                } else if (!submitTask) {
                    this.logger.error("task commit  failed , taskId {} has already retry {} times, please check", (Object)this.taskInstance.getId(), (Object)retryTimes);
                }
                Thread.sleep(commitRetryInterval.intValue());
                continue;
            }
            catch (Exception e) {
                this.logger.error("task commit to mysql and dispatcht task failed", (Throwable)e);
            }
        }
        return task;
    }

    public Boolean dispatchTask(TaskInstance taskInstance) {
        try {
            if (taskInstance.isConditionsTask() || taskInstance.isDependTask() || taskInstance.isSubProcess()) {
                return true;
            }
            if (taskInstance.getState().typeIsFinished()) {
                this.logger.info(String.format("submit task , but task [%s] state [%s] is already  finished. ", taskInstance.getName(), taskInstance.getState().toString()));
                return true;
            }
            if (taskInstance.getState() == ExecutionStatus.RUNNING_EXECUTION) {
                this.logger.info(String.format("submit to task, but task [%s] state already be running. ", taskInstance.getName()));
                return true;
            }
            this.logger.info("task ready to submit: {}", (Object)taskInstance);
            TaskPriority taskPriority = this.buildTaskPriority(this.processInstance.getProcessInstancePriority().getCode(), this.processInstance.getId(), taskInstance.getProcessInstancePriority().getCode(), taskInstance.getId(), "default");
            this.taskUpdateQueue.put((Object)taskPriority);
            this.logger.info(String.format("master submit success, task : %s", taskInstance.getName()));
            return true;
        }
        catch (Exception e) {
            this.logger.error("submit task  Exception: ", (Throwable)e);
            this.logger.error("task error : %s", (Object)JSONUtils.toJson((Object)taskInstance));
            return false;
        }
    }

    private TaskPriority buildTaskPriority(int processInstancePriority, int processInstanceId, int taskInstancePriority, int taskInstanceId, String workerGroup) {
        return new TaskPriority(processInstancePriority, processInstanceId, taskInstancePriority, taskInstanceId, workerGroup);
    }

    protected Boolean submitWaitComplete() {
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        this.processInstance = this.processService.findProcessInstanceById(this.taskInstance.getProcessInstanceId());
        return this.submitWaitComplete();
    }

    public String getTaskLogPath(TaskInstance task) {
        String logPath;
        try {
            String baseLog = ((TaskLogDiscriminator)((SiftingAppender)((LoggerContext)LoggerFactory.getILoggerFactory()).getLogger("ROOT").getAppender("TASKLOGFILE")).getDiscriminator()).getLogBase();
            logPath = baseLog.startsWith("/") ? baseLog + "/" + task.getProcessDefinitionId() + "/" + task.getProcessInstanceId() + "/" + task.getId() + ".log" : System.getProperty("user.dir") + "/" + baseLog + "/" + task.getProcessDefinitionId() + "/" + task.getProcessInstanceId() + "/" + task.getId() + ".log";
        }
        catch (Exception e) {
            this.logger.error("logger", (Throwable)e);
            logPath = "";
        }
        return logPath;
    }

    protected boolean alertTimeout() {
        if (TaskTimeoutStrategy.FAILED == this.taskTimeoutParameter.getStrategy()) {
            return true;
        }
        this.logger.warn("process id:{} process name:{} task id: {},name:{} execution time out", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.taskInstance.getId(), this.taskInstance.getName()});
        ProcessDefinition processDefine = this.processService.findProcessDefineById(this.processInstance.getProcessDefinitionId());
        this.alertDao.sendTaskTimeoutAlert(this.processInstance.getWarningGroupId().intValue(), processDefine.getReceivers(), processDefine.getReceiversCc(), this.processInstance.getId(), this.processInstance.getName(), this.taskInstance.getId(), this.taskInstance.getName());
        return true;
    }

    protected void handleTimeoutFailed() {
        if (TaskTimeoutStrategy.WARN == this.taskTimeoutParameter.getStrategy()) {
            return;
        }
        this.logger.info("process id:{} name:{} task id:{} name:{} cancel because of timeout.", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.taskInstance.getId(), this.taskInstance.getName()});
        this.cancel = true;
    }

    protected boolean checkTaskTimeout() {
        if (!this.checkTimeoutFlag || this.taskInstance.getStartTime() == null) {
            return false;
        }
        long remainTime = this.getRemainTime((long)this.taskTimeoutParameter.getInterval() * 60L);
        return remainTime <= 0L;
    }

    protected long getRemainTime(long timeoutSeconds) {
        Date startTime = this.taskInstance.getStartTime();
        long usedTime = (System.currentTimeMillis() - startTime.getTime()) / 1000L;
        return timeoutSeconds - usedTime;
    }
}

