/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.utils.EnumUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.datax.DataxTask;
import org.apache.dolphinscheduler.server.worker.task.flink.FlinkTask;
import org.apache.dolphinscheduler.server.worker.task.http.HttpTask;
import org.apache.dolphinscheduler.server.worker.task.mr.MapReduceTask;
import org.apache.dolphinscheduler.server.worker.task.processdure.ProcedureTask;
import org.apache.dolphinscheduler.server.worker.task.python.PythonTask;
import org.apache.dolphinscheduler.server.worker.task.shell.ShellTask;
import org.apache.dolphinscheduler.server.worker.task.spark.SparkTask;
import org.apache.dolphinscheduler.server.worker.task.sql.SqlTask;
import org.apache.dolphinscheduler.server.worker.task.sqoop.SqoopTask;
import org.slf4j.Logger;

public class TaskManager {
    public static AbstractTask newTask(TaskExecutionContext taskExecutionContext, Logger logger) throws IllegalArgumentException {
        switch ((TaskType)EnumUtils.getEnum(TaskType.class, (String)taskExecutionContext.getTaskType())) {
            case SHELL: {
                return new ShellTask(taskExecutionContext, logger);
            }
            case PROCEDURE: {
                return new ProcedureTask(taskExecutionContext, logger);
            }
            case SQL: {
                return new SqlTask(taskExecutionContext, logger);
            }
            case MR: {
                return new MapReduceTask(taskExecutionContext, logger);
            }
            case SPARK: {
                return new SparkTask(taskExecutionContext, logger);
            }
            case FLINK: {
                return new FlinkTask(taskExecutionContext, logger);
            }
            case PYTHON: {
                return new PythonTask(taskExecutionContext, logger);
            }
            case HTTP: {
                return new HttpTask(taskExecutionContext, logger);
            }
            case DATAX: {
                return new DataxTask(taskExecutionContext, logger);
            }
            case SQOOP: {
                return new SqoopTask(taskExecutionContext, logger);
            }
        }
        logger.error("unsupport task type: {}", (Object)taskExecutionContext.getTaskType());
        throw new IllegalArgumentException("not support task type");
    }
}

