/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.shell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.shell.ShellParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.CommandExecuteResult;
import org.apache.dolphinscheduler.server.worker.task.ShellCommandExecutor;
import org.slf4j.Logger;

public class ShellTask
extends AbstractTask {
    private ShellParameters shellParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskExecutionContext;

    public ShellTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskExecutionContext, logger);
    }

    @Override
    public void init() {
        this.logger.info("shell task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.shellParameters = (ShellParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), ShellParameters.class);
        if (!this.shellParameters.checkParameters()) {
            throw new RuntimeException("shell task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        try {
            CommandExecuteResult commandExecuteResult = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(commandExecuteResult.getAppIds());
            this.setProcessId(commandExecuteResult.getProcessId());
        }
        catch (Exception e) {
            this.logger.error("shell task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw e;
        }
    }

    @Override
    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.shellCommandExecutor.cancelApplication();
    }

    private String buildCommand() throws Exception {
        String fileName = String.format("%s/%s_node.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), OSUtils.isWindows() ? "bat" : "sh");
        Path path = new File(fileName).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            return fileName;
        }
        String script = this.shellParameters.getRawScript().replaceAll("\\r\\n", "\n");
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.shellParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
        if (MapUtils.isEmpty(paramsMap)) {
            paramsMap = new HashMap<String, Property>();
        }
        if (MapUtils.isNotEmpty(this.taskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.taskExecutionContext.getParamsMap());
        }
        script = ParameterUtils.convertParameterPlaceholders((String)script, ParamUtils.convert(paramsMap));
        this.shellParameters.setRawScript(script);
        this.logger.info("raw script : {}", (Object)this.shellParameters.getRawScript());
        this.logger.info("task execute path : {}", (Object)this.taskExecutionContext.getExecutePath());
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        if (OSUtils.isWindows()) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, attr);
        }
        Files.write(path, this.shellParameters.getRawScript().getBytes(), StandardOpenOption.APPEND);
        return fileName;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.shellParameters;
    }
}

