/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.SqoopJobGenerator;
import org.slf4j.Logger;

public class SqoopTask
extends AbstractYarnTask {
    private SqoopParameters sqoopParameters;
    private final TaskExecutionContext sqoopTaskExecutionContext;

    public SqoopTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.sqoopTaskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() {
        this.logger.info("sqoop task params {}", (Object)this.sqoopTaskExecutionContext.getTaskParams());
        this.sqoopParameters = (SqoopParameters)JSONUtils.parseObject((String)this.sqoopTaskExecutionContext.getTaskParams(), SqoopParameters.class);
        if (null == this.sqoopParameters) {
            throw new IllegalArgumentException("Sqoop Task params is null");
        }
        if (!this.sqoopParameters.checkParameters()) {
            throw new IllegalArgumentException("Sqoop Task params check fail");
        }
    }

    @Override
    protected String buildCommand() {
        SqoopJobGenerator generator = new SqoopJobGenerator();
        String script = generator.generateSqoopJob(this.sqoopParameters, this.sqoopTaskExecutionContext);
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.sqoopTaskExecutionContext.getDefinedParams()), this.sqoopTaskExecutionContext.getDefinedParams(), this.sqoopParameters.getLocalParametersMap(), CommandType.of((Integer)this.sqoopTaskExecutionContext.getCmdTypeIfComplement()), this.sqoopTaskExecutionContext.getScheduleTime());
        if (MapUtils.isEmpty(paramsMap)) {
            paramsMap = new HashMap<String, Property>();
        }
        if (MapUtils.isNotEmpty(this.sqoopTaskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.sqoopTaskExecutionContext.getParamsMap());
        }
        if (paramsMap != null) {
            String resultScripts = ParameterUtils.convertParameterPlaceholders((String)script, ParamUtils.convert(paramsMap));
            this.logger.info("sqoop script: {}", (Object)resultScripts);
            return resultScripts;
        }
        return null;
    }

    @Override
    protected void setMainJarName() {
    }

    @Override
    public AbstractParameters getParameters() {
        return this.sqoopParameters;
    }
}

