/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator;

import java.util.Collection;
import java.util.List;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CommonGenerator.class);

    public String generate(SqoopParameters sqoopParameters) {
        StringBuilder commonSb = new StringBuilder();
        try {
            List sqoopAdvancedParams;
            commonSb.append("sqoop").append(" ").append(sqoopParameters.getModelType());
            commonSb.append(" ").append("-D").append(" ").append(String.format("%s%s%s", "mapred.job.name", "=", sqoopParameters.getJobName()));
            List hadoopCustomParams = sqoopParameters.getHadoopCustomParams();
            if (CollectionUtils.isNotEmpty((Collection)hadoopCustomParams)) {
                StringBuilder hadoopCustomParamStr = new StringBuilder();
                for (Property hadoopCustomParam : hadoopCustomParams) {
                    hadoopCustomParamStr.append("-D").append(" ").append(hadoopCustomParam.getProp()).append("=").append(hadoopCustomParam.getValue()).append(" ");
                }
                commonSb.append(" ").append(hadoopCustomParamStr.substring(0, hadoopCustomParamStr.length() - 1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(sqoopAdvancedParams = sqoopParameters.getSqoopAdvancedParams()))) {
                for (Property sqoopAdvancedParam : sqoopAdvancedParams) {
                    commonSb.append(" ").append(sqoopAdvancedParam.getProp()).append(" ").append(sqoopAdvancedParam.getValue());
                }
            }
            if (sqoopParameters.getConcurrency() > 0) {
                commonSb.append(" ").append("-m").append(" ").append(sqoopParameters.getConcurrency());
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task general param build failed: [%s]", e.getMessage()));
        }
        return commonSb.toString();
    }
}

