/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator;

import org.apache.dolphinscheduler.common.enums.SqoopJobType;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.CommonGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources.HdfsSourceGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources.HiveSourceGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources.MysqlSourceGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets.HdfsTargetGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets.HiveTargetGenerator;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets.MysqlTargetGenerator;

public class SqoopJobGenerator {
    private static final String MYSQL = "MYSQL";
    private static final String HIVE = "HIVE";
    private static final String HDFS = "HDFS";
    private ITargetGenerator targetGenerator;
    private ISourceGenerator sourceGenerator;
    private final CommonGenerator commonGenerator = new CommonGenerator();

    private void createSqoopJobGenerator(String sourceType, String targetType) {
        this.sourceGenerator = this.createSourceGenerator(sourceType);
        this.targetGenerator = this.createTargetGenerator(targetType);
    }

    public String generateSqoopJob(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        String sqoopScripts = "";
        if (SqoopJobType.TEMPLATE.getDescp().equals(sqoopParameters.getJobType())) {
            this.createSqoopJobGenerator(sqoopParameters.getSourceType(), sqoopParameters.getTargetType());
            if (this.sourceGenerator == null || this.targetGenerator == null) {
                throw new RuntimeException("sqoop task source type or target type is null");
            }
            sqoopScripts = String.format("%s%s%s", this.commonGenerator.generate(sqoopParameters), this.sourceGenerator.generate(sqoopParameters, taskExecutionContext), this.targetGenerator.generate(sqoopParameters, taskExecutionContext));
        } else if (SqoopJobType.CUSTOM.getDescp().equals(sqoopParameters.getJobType())) {
            sqoopScripts = sqoopParameters.getCustomShell().replaceAll("\\r\\n", "\n");
        }
        return sqoopScripts;
    }

    private ISourceGenerator createSourceGenerator(String sourceType) {
        switch (sourceType) {
            case "MYSQL": {
                return new MysqlSourceGenerator();
            }
            case "HIVE": {
                return new HiveSourceGenerator();
            }
            case "HDFS": {
                return new HdfsSourceGenerator();
            }
        }
        return null;
    }

    private ITargetGenerator createTargetGenerator(String targetType) {
        switch (targetType) {
            case "MYSQL": {
                return new MysqlTargetGenerator();
            }
            case "HIVE": {
                return new HiveTargetGenerator();
            }
            case "HDFS": {
                return new HdfsTargetGenerator();
            }
        }
        return null;
    }
}

