/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets;

import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetHdfsParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HdfsTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder hdfsTargetSb = new StringBuilder();
        try {
            TargetHdfsParameter targetHdfsParameter = (TargetHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHdfsParameter.class);
            if (null != targetHdfsParameter) {
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getTargetPath())) {
                    hdfsTargetSb.append(" ").append("--target-dir").append(" ").append(targetHdfsParameter.getTargetPath());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getCompressionCodec())) {
                    hdfsTargetSb.append(" ").append("--compression-codec").append(" ").append(targetHdfsParameter.getCompressionCodec());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getFileType())) {
                    hdfsTargetSb.append(" ").append(targetHdfsParameter.getFileType());
                }
                if (targetHdfsParameter.isDeleteTargetDir()) {
                    hdfsTargetSb.append(" ").append("--delete-target-dir");
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getFieldsTerminated())) {
                    hdfsTargetSb.append(" ").append("--fields-terminated-by").append(" ").append("'").append(targetHdfsParameter.getFieldsTerminated()).append("'");
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getLinesTerminated())) {
                    hdfsTargetSb.append(" ").append("--lines-terminated-by").append(" ").append("'").append(targetHdfsParameter.getLinesTerminated()).append("'");
                }
                hdfsTargetSb.append(" ").append("--null-non-string 'NULL' --null-string 'NULL'");
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop hdfs target params build failed: [%s]", e.getMessage()));
        }
        return hdfsTargetSb.toString();
    }
}

