/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cache.impl;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.TaskExecuteAckCommand;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.server.master.cache.TaskInstanceCacheManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceCacheManagerImpl
implements TaskInstanceCacheManager {
    private Map<Integer, TaskInstance> taskInstanceCache = new ConcurrentHashMap<Integer, TaskInstance>();
    @Autowired
    private ProcessService processService;
    private Timer refreshTaskInstanceTimer = null;

    @PostConstruct
    public void init() {
        this.refreshTaskInstanceTimer = new Timer(true);
        this.refreshTaskInstanceTimer.scheduleAtFixedRate((TimerTask)new RefreshTaskInstanceTimerTask(), 20000L, 20000L);
    }

    @PreDestroy
    public void close() {
        this.refreshTaskInstanceTimer.cancel();
    }

    @Override
    public TaskInstance getByTaskInstanceId(Integer taskInstanceId) {
        return this.taskInstanceCache.computeIfAbsent(taskInstanceId, k -> this.processService.findTaskInstanceById(taskInstanceId));
    }

    @Override
    public void cacheTaskInstance(TaskExecutionContext taskExecutionContext) {
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setId(taskExecutionContext.getTaskInstanceId());
        taskInstance.setName(taskExecutionContext.getTaskName());
        taskInstance.setStartTime(taskExecutionContext.getStartTime());
        taskInstance.setTaskType(taskExecutionContext.getTaskType());
        taskInstance.setExecutePath(taskExecutionContext.getExecutePath());
        this.taskInstanceCache.put(taskExecutionContext.getTaskInstanceId(), taskInstance);
    }

    @Override
    public void cacheTaskInstance(TaskExecuteAckCommand taskAckCommand) {
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setState(ExecutionStatus.of((int)taskAckCommand.getStatus()));
        taskInstance.setStartTime(taskAckCommand.getStartTime());
        taskInstance.setHost(taskAckCommand.getHost());
        taskInstance.setExecutePath(taskAckCommand.getExecutePath());
        taskInstance.setLogPath(taskAckCommand.getLogPath());
        this.taskInstanceCache.put(taskAckCommand.getTaskInstanceId(), taskInstance);
    }

    @Override
    public void cacheTaskInstance(TaskExecuteResponseCommand taskExecuteResponseCommand) {
        TaskInstance taskInstance = this.getByTaskInstanceId(taskExecuteResponseCommand.getTaskInstanceId());
        taskInstance.setState(ExecutionStatus.of((int)taskExecuteResponseCommand.getStatus()));
        taskInstance.setEndTime(taskExecuteResponseCommand.getEndTime());
        this.taskInstanceCache.put(taskExecuteResponseCommand.getTaskInstanceId(), taskInstance);
    }

    @Override
    public void removeByTaskInstanceId(Integer taskInstanceId) {
        this.taskInstanceCache.remove(taskInstanceId);
    }

    class RefreshTaskInstanceTimerTask
    extends TimerTask {
        RefreshTaskInstanceTimerTask() {
        }

        @Override
        public void run() {
            for (Map.Entry taskInstanceEntry : TaskInstanceCacheManagerImpl.this.taskInstanceCache.entrySet()) {
                TaskInstance taskInstance = TaskInstanceCacheManagerImpl.this.processService.findTaskInstanceById((Integer)taskInstanceEntry.getKey());
                if (null == taskInstance || taskInstance.getState() != ExecutionStatus.NEED_FAULT_TOLERANCE) continue;
                TaskInstanceCacheManagerImpl.this.taskInstanceCache.computeIfPresent(taskInstanceEntry.getKey(), (k, v) -> taskInstance);
            }
        }
    }
}

