/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.host.CommonHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.LowerWeightHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.RandomHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.RoundRobinHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostSelector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HostManagerConfig {
    private AutowireCapableBeanFactory beanFactory;
    @Autowired
    private MasterConfig masterConfig;

    @Autowired
    public HostManagerConfig(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean
    public HostManager hostManager() {
        CommonHostManager hostManager;
        String hostSelector = this.masterConfig.getHostSelector();
        HostSelector selector = HostSelector.of(hostSelector);
        switch (selector) {
            case RANDOM: {
                hostManager = new RandomHostManager();
                break;
            }
            case ROUNDROBIN: {
                hostManager = new RoundRobinHostManager();
                break;
            }
            case LOWERWEIGHT: {
                hostManager = new LowerWeightHostManager();
                break;
            }
            default: {
                throw new IllegalArgumentException("unSupport selector " + hostSelector);
            }
        }
        this.beanFactory.autowireBean((Object)hostManager);
        return hostManager;
    }
}

