/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateWheelExecuteThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(StateWheelExecuteThread.class);
    ConcurrentHashMap<Integer, ProcessInstance> processInstanceCheckList;
    ConcurrentHashMap<Integer, TaskInstance> taskInstanceCheckList;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps;
    private int stateCheckIntervalSecs;

    public StateWheelExecuteThread(ConcurrentHashMap<Integer, ProcessInstance> processInstances, ConcurrentHashMap<Integer, TaskInstance> taskInstances, ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps, int stateCheckIntervalSecs) {
        this.processInstanceCheckList = processInstances;
        this.taskInstanceCheckList = taskInstances;
        this.processInstanceExecMaps = processInstanceExecMaps;
        this.stateCheckIntervalSecs = stateCheckIntervalSecs;
    }

    @Override
    public void run() {
        logger.info("state wheel thread start");
        while (Stopper.isRunning()) {
            try {
                this.checkProcess();
                this.checkTask();
            }
            catch (Exception e) {
                logger.error("state wheel thread check error:", (Throwable)e);
            }
            ThreadUtil.sleepAtLeastIgnoreInterrupts((long)this.stateCheckIntervalSecs);
        }
    }

    public boolean addProcess(ProcessInstance processInstance) {
        this.processInstanceCheckList.put(processInstance.getId(), processInstance);
        return true;
    }

    public boolean addTask(TaskInstance taskInstance) {
        this.taskInstanceCheckList.put(taskInstance.getId(), taskInstance);
        return true;
    }

    private void checkTask() {
        if (this.taskInstanceCheckList.isEmpty()) {
            return;
        }
        for (TaskInstance taskInstance : this.taskInstanceCheckList.values()) {
            long timeRemain;
            if (TimeoutFlag.OPEN == taskInstance.getTaskDefine().getTimeoutFlag() && 0L <= (timeRemain = DateUtils.getRemainTime((Date)taskInstance.getStartTime(), (long)(taskInstance.getTaskDefine().getTimeout() * 60))) && this.processTimeout(taskInstance)) {
                this.taskInstanceCheckList.remove(taskInstance.getId());
                return;
            }
            if (taskInstance.taskCanRetry() && taskInstance.retryTaskIntervalOverTime()) {
                this.processDependCheck(taskInstance);
                this.taskInstanceCheckList.remove(taskInstance.getId());
            }
            if (!taskInstance.isSubProcess() && !taskInstance.isDependTask()) continue;
            this.processDependCheck(taskInstance);
        }
    }

    private void checkProcess() {
        if (this.processInstanceCheckList.isEmpty()) {
            return;
        }
        for (ProcessInstance processInstance : this.processInstanceCheckList.values()) {
            long timeRemain = DateUtils.getRemainTime((Date)processInstance.getStartTime(), (long)(processInstance.getTimeout() * 60));
            if (0L > timeRemain || !this.processTimeout(processInstance)) continue;
            this.processInstanceCheckList.remove(processInstance.getId());
        }
    }

    private void putEvent(StateEvent stateEvent) {
        if (!this.processInstanceExecMaps.containsKey(stateEvent.getProcessInstanceId())) {
            return;
        }
        WorkflowExecuteThread workflowExecuteThread = this.processInstanceExecMaps.get(stateEvent.getProcessInstanceId());
        workflowExecuteThread.addStateEvent(stateEvent);
    }

    private boolean processDependCheck(TaskInstance taskInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
        stateEvent.setProcessInstanceId(taskInstance.getProcessInstanceId());
        stateEvent.setTaskInstanceId(taskInstance.getId());
        stateEvent.setExecutionStatus(ExecutionStatus.RUNNING_EXECUTION);
        this.putEvent(stateEvent);
        return true;
    }

    private boolean processTimeout(TaskInstance taskInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.TASK_TIMEOUT);
        stateEvent.setProcessInstanceId(taskInstance.getProcessInstanceId());
        stateEvent.setTaskInstanceId(taskInstance.getId());
        this.putEvent(stateEvent);
        return true;
    }

    private boolean processTimeout(ProcessInstance processInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.PROCESS_TIMEOUT);
        stateEvent.setProcessInstanceId(processInstance.getId());
        this.putEvent(stateEvent);
        return true;
    }
}

