/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.DependentItem;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.utils.LogUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.LoggerFactory;

public class ConditionTaskProcessor
extends BaseTaskProcessor {
    private DependentParameters dependentParameters;
    ProcessInstance processInstance;
    private DependResult conditionResult = DependResult.WAITING;
    private Map<String, ExecutionStatus> completeTaskList = new ConcurrentHashMap<String, ExecutionStatus>();
    MasterConfig masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
    private TaskDefinition taskDefinition;

    @Override
    public boolean submit(TaskInstance task, ProcessInstance processInstance, int masterTaskCommitRetryTimes, int masterTaskCommitInterval) {
        this.processInstance = processInstance;
        this.taskInstance = this.processService.submitTask(task, masterTaskCommitRetryTimes, masterTaskCommitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.taskDefinition = this.processService.findTaskDefinition(this.taskInstance.getTaskCode(), this.taskInstance.getTaskDefinitionVersion());
        this.logger = LoggerFactory.getLogger((String)LoggerUtils.buildTaskId((String)"TASK", (Long)processInstance.getProcessDefinitionCode(), (int)processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.processService.formatTaskAppId(this.taskInstance));
        Thread.currentThread().setName(threadLoggerInfoName);
        this.initTaskParameters();
        this.logger.info("dependent task start");
        return true;
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    @Override
    public void run() {
        if (this.conditionResult.equals((Object)DependResult.WAITING)) {
            this.setConditionResult();
            this.endTask();
        } else {
            this.endTask();
        }
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(ExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskDefinition.getTimeoutNotifyStrategy();
        if (taskTimeoutStrategy == TaskTimeoutStrategy.WARN) {
            return true;
        }
        this.logger.info("condition task {} timeout, strategy {} ", (Object)this.taskInstance.getId(), (Object)taskTimeoutStrategy.getDescp());
        this.conditionResult = DependResult.FAILED;
        this.endTask();
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    public String getType() {
        return TaskType.CONDITIONS.getDesc();
    }

    private void initTaskParameters() {
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion(), this.taskInstance.getProcessInstanceId(), this.taskInstance.getId()));
        this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.dependentParameters = this.taskInstance.getDependency();
    }

    private void setConditionResult() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        for (TaskInstance task : taskInstances) {
            this.completeTaskList.putIfAbsent(task.getName(), task.getState());
        }
        ArrayList<DependResult> modelResultList = new ArrayList<DependResult>();
        for (DependentTaskModel dependentTaskModel : this.dependentParameters.getDependTaskList()) {
            ArrayList<DependResult> itemDependResult = new ArrayList<DependResult>();
            for (DependentItem item : dependentTaskModel.getDependItemList()) {
                itemDependResult.add(this.getDependResultForItem(item));
            }
            DependResult modelResult = DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), itemDependResult);
            modelResultList.add(modelResult);
        }
        this.conditionResult = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), modelResultList);
        this.logger.info("the conditions task depend result : {}", (Object)this.conditionResult);
    }

    private DependResult getDependResultForItem(DependentItem item) {
        DependResult dependResult = DependResult.SUCCESS;
        if (!this.completeTaskList.containsKey(item.getDepTasks())) {
            this.logger.info("depend item: {} have not completed yet.", (Object)item.getDepTasks());
            dependResult = DependResult.FAILED;
            return dependResult;
        }
        ExecutionStatus executionStatus = this.completeTaskList.get(item.getDepTasks());
        if (executionStatus != item.getStatus()) {
            this.logger.info("depend item : {} expect status: {}, actual status: {}", new Object[]{item.getDepTasks(), item.getStatus(), executionStatus});
            dependResult = DependResult.FAILED;
        }
        this.logger.info("dependent item complete {} {},{}", new Object[]{":||", item.getDepTasks(), dependResult});
        return dependResult;
    }

    private void endTask() {
        ExecutionStatus status = this.conditionResult == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE;
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
    }
}

