/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchResultVo;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.utils.LogUtils;
import org.apache.dolphinscheduler.server.utils.SwitchTaskUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;

public class SwitchTaskProcessor
extends BaseTaskProcessor {
    protected final String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
    private TaskInstance taskInstance;
    private ProcessInstance processInstance;
    TaskDefinition taskDefinition;
    MasterConfig masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
    private DependResult conditionResult;

    @Override
    public boolean submit(TaskInstance taskInstance, ProcessInstance processInstance, int masterTaskCommitRetryTimes, int masterTaskCommitInterval) {
        this.processInstance = processInstance;
        this.taskInstance = this.processService.submitTask(taskInstance, masterTaskCommitRetryTimes, masterTaskCommitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.taskDefinition = this.processService.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
        taskInstance.setLogPath(LogUtils.getTaskLogPath(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), taskInstance.getProcessInstanceId(), taskInstance.getId()));
        taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(taskInstance);
        return true;
    }

    @Override
    public void run() {
        try {
            if (!this.taskState().typeIsFinished() && this.setSwitchResult()) {
                this.endTaskState();
            }
        }
        catch (Exception e) {
            this.logger.error("update work flow {} switch task {} state error:", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), e});
        }
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(ExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    public String getType() {
        return TaskType.SWITCH.getDesc();
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    private boolean setSwitchResult() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        HashMap<String, ExecutionStatus> completeTaskList = new HashMap<String, ExecutionStatus>();
        for (TaskInstance task : taskInstances) {
            completeTaskList.putIfAbsent(task.getName(), task.getState());
        }
        SwitchParameters switchParameters = this.taskInstance.getSwitchDependency();
        List switchResultVos = switchParameters.getDependTaskList();
        SwitchResultVo switchResultVo = new SwitchResultVo();
        switchResultVo.setNextNode((Object)switchParameters.getNextNode());
        switchResultVos.add(switchResultVo);
        int finalConditionLocation = switchResultVos.size() - 1;
        int i = 0;
        this.conditionResult = DependResult.SUCCESS;
        for (SwitchResultVo info : switchResultVos) {
            this.logger.info("the {} execution ", (Object)(i + 1));
            this.logger.info("original condition sentence\uff1a{}", (Object)info.getCondition());
            if (StringUtils.isEmpty((String)info.getCondition())) {
                finalConditionLocation = i;
                break;
            }
            String content = this.setTaskParams(info.getCondition().replaceAll("'", "\""), "['\"]*\\$\\{(.*?)\\}['\"]*");
            this.logger.info("format condition sentence::{}", (Object)content);
            Boolean result = null;
            try {
                result = SwitchTaskUtils.evaluate(content);
            }
            catch (Exception e) {
                this.logger.info("error sentence : {}", (Object)content);
                this.conditionResult = DependResult.FAILED;
                break;
            }
            this.logger.info("condition result : {}", (Object)result);
            if (result.booleanValue()) {
                finalConditionLocation = i;
                break;
            }
            ++i;
        }
        switchParameters.setDependTaskList(switchResultVos);
        switchParameters.setResultConditionLocation(finalConditionLocation);
        this.taskInstance.setSwitchDependency(switchParameters);
        this.logger.info("the switch task depend result : {}", (Object)this.conditionResult);
        return true;
    }

    private void endTaskState() {
        ExecutionStatus status = this.conditionResult == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE;
        this.taskInstance.setEndTime(new Date());
        this.taskInstance.setState(status);
        this.processService.updateTaskInstance(this.taskInstance);
    }

    public String setTaskParams(String content, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        Map<String, Property> globalParams = JSONUtils.toList((String)this.processInstance.getGlobalParams(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        Map<String, Property> varParams = JSONUtils.toList((String)this.taskInstance.getVarPool(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        if (varParams.size() > 0) {
            varParams.putAll(globalParams);
            globalParams = varParams;
        }
        while (m.find()) {
            String paramName = m.group(1);
            Property property = globalParams.get(paramName);
            if (property == null) {
                return "";
            }
            String value = property.getValue();
            if (!NumberUtils.isNumber((String)value)) {
                value = "\"" + value + "\"";
            }
            this.logger.info("paramName\uff1a{}\uff0cparamValue{}", (Object)paramName, (Object)value);
            content = content.replace("${" + paramName + "}", value);
        }
        return content;
    }
}

