/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.monitor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.server.monitor.Monitor;
import org.apache.dolphinscheduler.server.monitor.RunConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractMonitor
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitor.class);
    @Autowired
    private RunConfig runConfig;

    @Override
    public void monitor(String masterPath, String workerPath, Integer port, String installPath) {
        try {
            this.restartServer(masterPath, port, installPath);
            this.restartServer(workerPath, port, installPath);
        }
        catch (Exception e) {
            logger.error("server start up error", (Throwable)e);
        }
    }

    private void restartServer(String path, Integer port, String installPath) throws Exception {
        String type = path.split("/")[2];
        String serverName = null;
        String nodes = null;
        if ("masters".equals(type)) {
            serverName = "master-server";
            nodes = this.runConfig.getMasters();
        } else if ("workers".equals(type)) {
            serverName = "worker-server";
            nodes = this.runConfig.getWorkers();
        }
        Map<String, String> activeNodeMap = this.getActiveNodesByPath(path);
        Set<String> needRestartServer = this.getNeedRestartServer(this.getRunConfigServer(nodes), activeNodeMap.keySet());
        for (String node : needRestartServer) {
            String runCmd = "ssh -p " + port + " " + node + " sh " + installPath + "/bin/dolphinscheduler-daemon.sh start " + serverName;
            Runtime.getRuntime().exec(runCmd);
        }
    }

    private Set<String> getNeedRestartServer(Set<String> deployedNodes, Set<String> activeNodes) {
        if (CollectionUtils.isEmpty(activeNodes)) {
            return deployedNodes;
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(deployedNodes);
        result.removeAll(activeNodes);
        return result;
    }

    private Set<String> getRunConfigServer(String nodes) {
        String[] nodeArr;
        HashSet<String> nodeSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)nodes)) {
            return null;
        }
        for (String node : nodeArr = nodes.split(",")) {
            nodeSet.add(node);
        }
        return nodeSet;
    }

    protected abstract Map<String, String> getActiveNodesByPath(String var1);
}

