/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.plugin.TaskPluginManager;
import org.apache.dolphinscheduler.server.worker.processor.DBTaskAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.DBTaskResponseProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskKillProcessor;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistryClient;
import org.apache.dolphinscheduler.server.worker.runner.RetryReportTaskStatusThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.alert.AlertClientService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.spi.exception.PluginNotFoundException;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginLoader;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginManagerConfig;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@ComponentScan(value={"org.apache.dolphinscheduler"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"org.apache.dolphinscheduler.server.master.*", "org.apache.dolphinscheduler.server.monitor.*", "org.apache.dolphinscheduler.server.log.*"})})
@EnableTransactionManagement
public class WorkerServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerServer.class);
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    private AlertClientService alertClientService;
    @Autowired
    private RetryReportTaskStatusThread retryReportTaskStatusThread;
    @Autowired
    private WorkerManagerThread workerManagerThread;
    @Autowired
    private WorkerRegistryClient workerRegistryClient;
    private TaskPluginManager taskPluginManager;

    public static void main(String[] args) {
        Thread.currentThread().setName("Worker-Server");
        new SpringApplicationBuilder(new Class[]{WorkerServer.class}).web(WebApplicationType.NONE).run(args);
    }

    @PostConstruct
    public void run() {
        this.alertClientService = new AlertClientService(this.workerConfig.getAlertListenHost(), 50052);
        this.initTaskPlugin();
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.workerConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_REQUEST, (NettyRequestProcessor)new TaskExecuteProcessor(this.alertClientService, this.taskPluginManager));
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_REQUEST, (NettyRequestProcessor)new TaskKillProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.DB_TASK_ACK, (NettyRequestProcessor)new DBTaskAckProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.DB_TASK_RESPONSE, (NettyRequestProcessor)new DBTaskResponseProcessor());
        this.nettyRemotingServer.start();
        try {
            this.workerRegistryClient.registry();
            this.workerRegistryClient.setRegistryStoppable(this);
            Set<String> workerZkPaths = this.workerRegistryClient.getWorkerZkPaths();
            this.workerRegistryClient.handleDeadServer(workerZkPaths, NodeType.WORKER, "delete");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.workerManagerThread.start();
        this.retryReportTaskStatusThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Stopper.isRunning()) {
                this.close("shutdownHook");
            }
        }));
    }

    private void initTaskPlugin() {
        this.taskPluginManager = new TaskPluginManager();
        DolphinPluginManagerConfig taskPluginManagerConfig = new DolphinPluginManagerConfig();
        taskPluginManagerConfig.setPlugins(this.workerConfig.getTaskPluginBinding());
        if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getTaskPluginDir())) {
            taskPluginManagerConfig.setInstalledPluginsDir(this.workerConfig.getTaskPluginDir().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getMavenLocalRepository())) {
            taskPluginManagerConfig.setMavenLocalRepository(this.workerConfig.getMavenLocalRepository().trim());
        }
        DolphinPluginLoader taskPluginLoader = new DolphinPluginLoader(taskPluginManagerConfig, (List)ImmutableList.of((Object)((Object)this.taskPluginManager)));
        try {
            taskPluginLoader.loadPlugins();
        }
        catch (Exception e) {
            throw new RuntimeException("Load Task Plugin Failed !", e);
        }
        if (MapUtils.isEmpty(this.taskPluginManager.getTaskChannelMap())) {
            throw new PluginNotFoundException("Task Plugin Not Found,Please Check Config File");
        }
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("worker server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception", (Throwable)e);
            }
            this.nettyRemotingServer.close();
            this.workerRegistryClient.unRegistry();
            this.alertClientService.close();
            this.springApplicationContext.close();
        }
        catch (Exception e) {
            logger.error("worker server stop exception ", (Throwable)e);
        }
    }

    public void stop(String cause) {
        this.close(cause);
    }
}

